@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HoneyPot].
 */
@PulumiTagMarker
public class HoneyPotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HoneyPotArgs = HoneyPotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HoneyPotArgsBuilder.() -> Unit) {
        val builder = HoneyPotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HoneyPot {
        val builtJavaResource = com.pulumi.alicloud.threatdetection.HoneyPot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HoneyPot(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Honey Pot resource.
 * For information about Threat Detection Honey Pot and how to use it, see [What is Honey Pot](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypot).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.threatdetection.getHoneypotImages({
 *     nameRegex: "^ruoyi",
 * });
 * const defaultHoneypotNode = new alicloud.threatdetection.HoneypotNode("default", {
 *     nodeName: name,
 *     availableProbeNum: 20,
 *     securityGroupProbeIpLists: ["0&#46;0&#46;0&#46;0/0"],
 * });
 * const defaultHoneyPot = new alicloud.threatdetection.HoneyPot("default", {
 *     honeypotImageName: _default.then(_default => _default.images?.[0]?.honeypotImageName),
 *     honeypotImageId: _default.then(_default => _default.images?.[0]?.honeypotImageId),
 *     honeypotName: name,
 *     nodeId: defaultHoneypotNode.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.threatdetection.get_honeypot_images(name_regex="^ruoyi")
 * default_honeypot_node = alicloud.threatdetection.HoneypotNode("default",
 *     node_name=name,
 *     available_probe_num=20,
 *     security_group_probe_ip_lists=["0&#46;0&#46;0&#46;0/0"])
 * default_honey_pot = alicloud.threatdetection.HoneyPot("default",
 *     honeypot_image_name=default.images[0].honeypot_image_name,
 *     honeypot_image_id=default.images[0].honeypot_image_id,
 *     honeypot_name=name,
 *     node_id=default_honeypot_node.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.ThreatDetection.GetHoneypotImages.Invoke(new()
 *     {
 *         NameRegex = "^ruoyi",
 *     });
 *     var defaultHoneypotNode = new AliCloud.ThreatDetection.HoneypotNode("default", new()
 *     {
 *         NodeName = name,
 *         AvailableProbeNum = 20,
 *         SecurityGroupProbeIpLists = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *     });
 *     var defaultHoneyPot = new AliCloud.ThreatDetection.HoneyPot("default", new()
 *     {
 *         HoneypotImageName = @default.Apply(@default => @default.Apply(getHoneypotImagesResult => getHoneypotImagesResult.Images[0]?.HoneypotImageName)),
 *         HoneypotImageId = @default.Apply(@default => @default.Apply(getHoneypotImagesResult => getHoneypotImagesResult.Images[0]?.HoneypotImageId)),
 *         HoneypotName = name,
 *         NodeId = defaultHoneypotNode.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := threatdetection.GetHoneypotImages(ctx, &threatdetection.GetHoneypotImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ruoyi"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultHoneypotNode, err := threatdetection.NewHoneypotNode(ctx, "default", &threatdetection.HoneypotNodeArgs{
 * 			NodeName:          pulumi.String(name),
 * 			AvailableProbeNum: pulumi.Int(20),
 * 			SecurityGroupProbeIpLists: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewHoneyPot(ctx, "default", &threatdetection.HoneyPotArgs{
 * 			HoneypotImageName: pulumi.String(_default.Images[0].HoneypotImageName),
 * 			HoneypotImageId:   pulumi.String(_default.Images[0].HoneypotImageId),
 * 			HoneypotName:      pulumi.String(name),
 * 			NodeId:            defaultHoneypotNode.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesArgs;
 * import com.pulumi.alicloud.threatdetection.HoneypotNode;
 * import com.pulumi.alicloud.threatdetection.HoneypotNodeArgs;
 * import com.pulumi.alicloud.threatdetection.HoneyPot;
 * import com.pulumi.alicloud.threatdetection.HoneyPotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = ThreatdetectionFunctions.getHoneypotImages(GetHoneypotImagesArgs.builder()
 *             .nameRegex("^ruoyi")
 *             .build());
 *         var defaultHoneypotNode = new HoneypotNode("defaultHoneypotNode", HoneypotNodeArgs.builder()
 *             .nodeName(name)
 *             .availableProbeNum(20)
 *             .securityGroupProbeIpLists("0.0.0.0/0")
 *             .build());
 *         var defaultHoneyPot = new HoneyPot("defaultHoneyPot", HoneyPotArgs.builder()
 *             .honeypotImageName(default_.images()[0].honeypotImageName())
 *             .honeypotImageId(default_.images()[0].honeypotImageId())
 *             .honeypotName(name)
 *             .nodeId(defaultHoneypotNode.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   defaultHoneypotNode:
 *     type: alicloud:threatdetection:HoneypotNode
 *     name: default
 *     properties:
 *       nodeName: ${name}
 *       availableProbeNum: 20
 *       securityGroupProbeIpLists:
 *         - 0.0.0.0/0
 *   defaultHoneyPot:
 *     type: alicloud:threatdetection:HoneyPot
 *     name: default
 *     properties:
 *       honeypotImageName: ${default.images[0].honeypotImageName}
 *       honeypotImageId: ${default.images[0].honeypotImageId}
 *       honeypotName: ${name}
 *       nodeId: ${defaultHoneypotNode.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getHoneypotImages
 *       Arguments:
 *         nameRegex: ^ruoyi
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honey Pot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeyPot:HoneyPot example <id>
 * ```
 */
public class HoneyPot internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.HoneyPot,
) : KotlinCustomResource(javaResource, HoneyPotMapper) {
    /**
     * Honeypot ID.
     */
    public val honeypotId: Output<String>
        get() = javaResource.honeypotId().applyValue({ args0 -> args0 })

    /**
     * The image ID of the honeypot.
     */
    public val honeypotImageId: Output<String>
        get() = javaResource.honeypotImageId().applyValue({ args0 -> args0 })

    /**
     * Honeypot mirror name.
     */
    public val honeypotImageName: Output<String>
        get() = javaResource.honeypotImageName().applyValue({ args0 -> args0 })

    /**
     * Honeypot custom name.
     */
    public val honeypotName: Output<String>
        get() = javaResource.honeypotName().applyValue({ args0 -> args0 })

    /**
     * The ID of the honeypot management node.
     */
    public val nodeId: Output<String>
        get() = javaResource.nodeId().applyValue({ args0 -> args0 })

    /**
     * The custom parameter ID of honeypot.
     */
    public val presetId: Output<String>
        get() = javaResource.presetId().applyValue({ args0 -> args0 })

    /**
     * Honeypot status.
     */
    public val states: Output<List<String>>
        get() = javaResource.states().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object HoneyPotMapper : ResourceMapper<HoneyPot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.HoneyPot::class == javaResource::class

    override fun map(javaResource: Resource): HoneyPot = HoneyPot(
        javaResource as
            com.pulumi.alicloud.threatdetection.HoneyPot,
    )
}

/**
 * @see [HoneyPot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HoneyPot].
 */
public suspend fun honeyPot(name: String, block: suspend HoneyPotResourceBuilder.() -> Unit): HoneyPot {
    val builder = HoneyPotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HoneyPot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun honeyPot(name: String): HoneyPot {
    val builder = HoneyPotResourceBuilder()
    builder.name(name)
    return builder.build()
}
