@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HoneypotNode].
 */
@PulumiTagMarker
public class HoneypotNodeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HoneypotNodeArgs = HoneypotNodeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HoneypotNodeArgsBuilder.() -> Unit) {
        val builder = HoneypotNodeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HoneypotNode {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.HoneypotNode(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HoneypotNode(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Honeypot Node resource.
 * For information about Threat Detection Honeypot Node and how to use it, see [What is Honeypot Node](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotnode).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.threatdetection.HoneypotNode("default", {
 *     nodeName: name,
 *     availableProbeNum: 20,
 *     securityGroupProbeIpLists: ["0&#46;0&#46;0&#46;0/0"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.threatdetection.HoneypotNode("default",
 *     node_name=name,
 *     available_probe_num=20,
 *     security_group_probe_ip_lists=["0&#46;0&#46;0&#46;0/0"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ThreatDetection.HoneypotNode("default", new()
 *     {
 *         NodeName = name,
 *         AvailableProbeNum = 20,
 *         SecurityGroupProbeIpLists = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewHoneypotNode(ctx, "default", &threatdetection.HoneypotNodeArgs{
 * 			NodeName:          pulumi.String(name),
 * 			AvailableProbeNum: pulumi.Int(20),
 * 			SecurityGroupProbeIpLists: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.HoneypotNode;
 * import com.pulumi.alicloud.threatdetection.HoneypotNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new HoneypotNode("default", HoneypotNodeArgs.builder()
 *             .nodeName(name)
 *             .availableProbeNum(20)
 *             .securityGroupProbeIpLists("0.0.0.0/0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:HoneypotNode
 *     properties:
 *       nodeName: ${name}
 *       availableProbeNum: 20
 *       securityGroupProbeIpLists:
 *         - 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honeypot Node can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeypotNode:HoneypotNode example <id>
 * ```
 */
public class HoneypotNode internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.HoneypotNode,
) : KotlinCustomResource(javaResource, HoneypotNodeMapper) {
    /**
     * Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
     */
    public val allowHoneypotAccessInternet: Output<Boolean>?
        get() = javaResource.allowHoneypotAccessInternet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of probes available.
     */
    public val availableProbeNum: Output<Int>
        get() = javaResource.availableProbeNum().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Management node name.
     */
    public val nodeName: Output<String>
        get() = javaResource.nodeName().applyValue({ args0 -> args0 })

    /**
     * Release the collection of network segments.
     */
    public val securityGroupProbeIpLists: Output<List<String>>?
        get() = javaResource.securityGroupProbeIpLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The status of the resource
     */
    public val status: Output<Int>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object HoneypotNodeMapper : ResourceMapper<HoneypotNode> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.HoneypotNode::class == javaResource::class

    override fun map(javaResource: Resource): HoneypotNode = HoneypotNode(
        javaResource as
            com.pulumi.alicloud.threatdetection.HoneypotNode,
    )
}

/**
 * @see [HoneypotNode].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HoneypotNode].
 */
public suspend fun honeypotNode(
    name: String,
    block: suspend HoneypotNodeResourceBuilder.() -> Unit,
): HoneypotNode {
    val builder = HoneypotNodeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HoneypotNode].
 * @param name The _unique_ name of the resulting resource.
 */
public fun honeypotNode(name: String): HoneypotNode {
    val builder = HoneypotNodeResourceBuilder()
    builder.name(name)
    return builder.build()
}
