@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.HoneypotNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Honeypot Node resource.
 * For information about Threat Detection Honeypot Node and how to use it, see [What is Honeypot Node](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotnode).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const _default = new alicloud.threatdetection.HoneypotNode("default", {
 *     nodeName: name,
 *     availableProbeNum: 20,
 *     securityGroupProbeIpLists: ["0&#46;0&#46;0&#46;0/0"],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * default = alicloud.threatdetection.HoneypotNode("default",
 *     node_name=name,
 *     available_probe_num=20,
 *     security_group_probe_ip_lists=["0&#46;0&#46;0&#46;0/0"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var @default = new AliCloud.ThreatDetection.HoneypotNode("default", new()
 *     {
 *         NodeName = name,
 *         AvailableProbeNum = 20,
 *         SecurityGroupProbeIpLists = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewHoneypotNode(ctx, "default", &threatdetection.HoneypotNodeArgs{
 * 			NodeName:          pulumi.String(name),
 * 			AvailableProbeNum: pulumi.Int(20),
 * 			SecurityGroupProbeIpLists: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.HoneypotNode;
 * import com.pulumi.alicloud.threatdetection.HoneypotNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         var default_ = new HoneypotNode("default", HoneypotNodeArgs.builder()
 *             .nodeName(name)
 *             .availableProbeNum(20)
 *             .securityGroupProbeIpLists("0.0.0.0/0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:HoneypotNode
 *     properties:
 *       nodeName: ${name}
 *       availableProbeNum: 20
 *       securityGroupProbeIpLists:
 *         - 0.0.0.0/0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honeypot Node can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeypotNode:HoneypotNode example <id>
 * ```
 * @property allowHoneypotAccessInternet Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
 * @property availableProbeNum Number of probes available.
 * @property nodeName Management node name.
 * @property securityGroupProbeIpLists Release the collection of network segments.
 */
public data class HoneypotNodeArgs(
    public val allowHoneypotAccessInternet: Output<Boolean>? = null,
    public val availableProbeNum: Output<Int>? = null,
    public val nodeName: Output<String>? = null,
    public val securityGroupProbeIpLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.HoneypotNodeArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.HoneypotNodeArgs =
        com.pulumi.alicloud.threatdetection.HoneypotNodeArgs.builder()
            .allowHoneypotAccessInternet(allowHoneypotAccessInternet?.applyValue({ args0 -> args0 }))
            .availableProbeNum(availableProbeNum?.applyValue({ args0 -> args0 }))
            .nodeName(nodeName?.applyValue({ args0 -> args0 }))
            .securityGroupProbeIpLists(
                securityGroupProbeIpLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [HoneypotNodeArgs].
 */
@PulumiTagMarker
public class HoneypotNodeArgsBuilder internal constructor() {
    private var allowHoneypotAccessInternet: Output<Boolean>? = null

    private var availableProbeNum: Output<Int>? = null

    private var nodeName: Output<String>? = null

    private var securityGroupProbeIpLists: Output<List<String>>? = null

    /**
     * @param value Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
     */
    @JvmName("txlbqooegwnbonab")
    public suspend fun allowHoneypotAccessInternet(`value`: Output<Boolean>) {
        this.allowHoneypotAccessInternet = value
    }

    /**
     * @param value Number of probes available.
     */
    @JvmName("jkoxnndpojcxcosk")
    public suspend fun availableProbeNum(`value`: Output<Int>) {
        this.availableProbeNum = value
    }

    /**
     * @param value Management node name.
     */
    @JvmName("vtotffkuobgxfnex")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value Release the collection of network segments.
     */
    @JvmName("qlflaknvanswtxai")
    public suspend fun securityGroupProbeIpLists(`value`: Output<List<String>>) {
        this.securityGroupProbeIpLists = value
    }

    @JvmName("urlaqmcuryqoxjwe")
    public suspend fun securityGroupProbeIpLists(vararg values: Output<String>) {
        this.securityGroupProbeIpLists = Output.all(values.asList())
    }

    /**
     * @param values Release the collection of network segments.
     */
    @JvmName("wujanexijkvnwvnm")
    public suspend fun securityGroupProbeIpLists(values: List<Output<String>>) {
        this.securityGroupProbeIpLists = Output.all(values)
    }

    /**
     * @param value Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
     */
    @JvmName("hibhhktgrculnohh")
    public suspend fun allowHoneypotAccessInternet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHoneypotAccessInternet = mapped
    }

    /**
     * @param value Number of probes available.
     */
    @JvmName("yairgmrjonyblttu")
    public suspend fun availableProbeNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availableProbeNum = mapped
    }

    /**
     * @param value Management node name.
     */
    @JvmName("xerolvpnhugenwwe")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    /**
     * @param value Release the collection of network segments.
     */
    @JvmName("ljxfebpryhxjyayn")
    public suspend fun securityGroupProbeIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupProbeIpLists = mapped
    }

    /**
     * @param values Release the collection of network segments.
     */
    @JvmName("xvesqipamlylywrc")
    public suspend fun securityGroupProbeIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupProbeIpLists = mapped
    }

    internal fun build(): HoneypotNodeArgs = HoneypotNodeArgs(
        allowHoneypotAccessInternet = allowHoneypotAccessInternet,
        availableProbeNum = availableProbeNum,
        nodeName = nodeName,
        securityGroupProbeIpLists = securityGroupProbeIpLists,
    )
}
