@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.HoneypotPresetArgs.builder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.HoneypotPresetMetaArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.HoneypotPresetMetaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Honeypot Preset resource.
 * For information about Threat Detection Honeypot Preset and how to use it, see [What is Honeypot Preset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotpreset).
 * > **NOTE:** Available since v1.195.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.threatdetection.getHoneypotImages({
 *     nameRegex: "^ruoyi",
 * });
 * const defaultHoneypotNode = new alicloud.threatdetection.HoneypotNode("default", {
 *     nodeName: name,
 *     availableProbeNum: 20,
 *     securityGroupProbeIpLists: ["0&#46;0&#46;0&#46;0/0"],
 * });
 * const defaultHoneypotPreset = new alicloud.threatdetection.HoneypotPreset("default", {
 *     presetName: name,
 *     nodeId: defaultHoneypotNode.id,
 *     honeypotImageName: _default.then(_default => _default.images?.[0]?.honeypotImageName),
 *     meta: {
 *         portraitOption: true,
 *         burp: "open",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.threatdetection.get_honeypot_images(name_regex="^ruoyi")
 * default_honeypot_node = alicloud.threatdetection.HoneypotNode("default",
 *     node_name=name,
 *     available_probe_num=20,
 *     security_group_probe_ip_lists=["0&#46;0&#46;0&#46;0/0"])
 * default_honeypot_preset = alicloud.threatdetection.HoneypotPreset("default",
 *     preset_name=name,
 *     node_id=default_honeypot_node.id,
 *     honeypot_image_name=default.images[0].honeypot_image_name,
 *     meta={
 *         "portrait_option": True,
 *         "burp": "open",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.ThreatDetection.GetHoneypotImages.Invoke(new()
 *     {
 *         NameRegex = "^ruoyi",
 *     });
 *     var defaultHoneypotNode = new AliCloud.ThreatDetection.HoneypotNode("default", new()
 *     {
 *         NodeName = name,
 *         AvailableProbeNum = 20,
 *         SecurityGroupProbeIpLists = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *     });
 *     var defaultHoneypotPreset = new AliCloud.ThreatDetection.HoneypotPreset("default", new()
 *     {
 *         PresetName = name,
 *         NodeId = defaultHoneypotNode.Id,
 *         HoneypotImageName = @default.Apply(@default => @default.Apply(getHoneypotImagesResult => getHoneypotImagesResult.Images[0]?.HoneypotImageName)),
 *         Meta = new AliCloud.ThreatDetection.Inputs.HoneypotPresetMetaArgs
 *         {
 *             PortraitOption = true,
 *             Burp = "open",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := threatdetection.GetHoneypotImages(ctx, &threatdetection.GetHoneypotImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ruoyi"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultHoneypotNode, err := threatdetection.NewHoneypotNode(ctx, "default", &threatdetection.HoneypotNodeArgs{
 * 			NodeName:          pulumi.String(name),
 * 			AvailableProbeNum: pulumi.Int(20),
 * 			SecurityGroupProbeIpLists: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewHoneypotPreset(ctx, "default", &threatdetection.HoneypotPresetArgs{
 * 			PresetName:        pulumi.String(name),
 * 			NodeId:            defaultHoneypotNode.ID(),
 * 			HoneypotImageName: pulumi.String(_default.Images[0].HoneypotImageName),
 * 			Meta: &threatdetection.HoneypotPresetMetaArgs{
 * 				PortraitOption: pulumi.Bool(true),
 * 				Burp:           pulumi.String("open"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesArgs;
 * import com.pulumi.alicloud.threatdetection.HoneypotNode;
 * import com.pulumi.alicloud.threatdetection.HoneypotNodeArgs;
 * import com.pulumi.alicloud.threatdetection.HoneypotPreset;
 * import com.pulumi.alicloud.threatdetection.HoneypotPresetArgs;
 * import com.pulumi.alicloud.threatdetection.inputs.HoneypotPresetMetaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = ThreatdetectionFunctions.getHoneypotImages(GetHoneypotImagesArgs.builder()
 *             .nameRegex("^ruoyi")
 *             .build());
 *         var defaultHoneypotNode = new HoneypotNode("defaultHoneypotNode", HoneypotNodeArgs.builder()
 *             .nodeName(name)
 *             .availableProbeNum(20)
 *             .securityGroupProbeIpLists("0.0.0.0/0")
 *             .build());
 *         var defaultHoneypotPreset = new HoneypotPreset("defaultHoneypotPreset", HoneypotPresetArgs.builder()
 *             .presetName(name)
 *             .nodeId(defaultHoneypotNode.id())
 *             .honeypotImageName(default_.images()[0].honeypotImageName())
 *             .meta(HoneypotPresetMetaArgs.builder()
 *                 .portraitOption(true)
 *                 .burp("open")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   defaultHoneypotNode:
 *     type: alicloud:threatdetection:HoneypotNode
 *     name: default
 *     properties:
 *       nodeName: ${name}
 *       availableProbeNum: 20
 *       securityGroupProbeIpLists:
 *         - 0.0.0.0/0
 *   defaultHoneypotPreset:
 *     type: alicloud:threatdetection:HoneypotPreset
 *     name: default
 *     properties:
 *       presetName: ${name}
 *       nodeId: ${defaultHoneypotNode.id}
 *       honeypotImageName: ${default.images[0].honeypotImageName}
 *       meta:
 *         portraitOption: true
 *         burp: open
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getHoneypotImages
 *       Arguments:
 *         nameRegex: ^ruoyi
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honeypot Preset can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeypotPreset:HoneypotPreset example <id>
 * ```
 * @property honeypotImageName Honeypot mirror name
 * @property meta Honeypot template custom parameters. See `meta` below.
 * @property nodeId Unique id of management node
 * @property presetName Honeypot template custom name
 */
public data class HoneypotPresetArgs(
    public val honeypotImageName: Output<String>? = null,
    public val meta: Output<HoneypotPresetMetaArgs>? = null,
    public val nodeId: Output<String>? = null,
    public val presetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.HoneypotPresetArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.HoneypotPresetArgs =
        com.pulumi.alicloud.threatdetection.HoneypotPresetArgs.builder()
            .honeypotImageName(honeypotImageName?.applyValue({ args0 -> args0 }))
            .meta(meta?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeId(nodeId?.applyValue({ args0 -> args0 }))
            .presetName(presetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoneypotPresetArgs].
 */
@PulumiTagMarker
public class HoneypotPresetArgsBuilder internal constructor() {
    private var honeypotImageName: Output<String>? = null

    private var meta: Output<HoneypotPresetMetaArgs>? = null

    private var nodeId: Output<String>? = null

    private var presetName: Output<String>? = null

    /**
     * @param value Honeypot mirror name
     */
    @JvmName("getpavcceuekwhhx")
    public suspend fun honeypotImageName(`value`: Output<String>) {
        this.honeypotImageName = value
    }

    /**
     * @param value Honeypot template custom parameters. See `meta` below.
     */
    @JvmName("pfjliovpdlmpcksi")
    public suspend fun meta(`value`: Output<HoneypotPresetMetaArgs>) {
        this.meta = value
    }

    /**
     * @param value Unique id of management node
     */
    @JvmName("wnhwopsoicackuul")
    public suspend fun nodeId(`value`: Output<String>) {
        this.nodeId = value
    }

    /**
     * @param value Honeypot template custom name
     */
    @JvmName("ucmaocnqrlhpfrey")
    public suspend fun presetName(`value`: Output<String>) {
        this.presetName = value
    }

    /**
     * @param value Honeypot mirror name
     */
    @JvmName("geyqixrctrdursmy")
    public suspend fun honeypotImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeypotImageName = mapped
    }

    /**
     * @param value Honeypot template custom parameters. See `meta` below.
     */
    @JvmName("bsuwqyuwhcrpndud")
    public suspend fun meta(`value`: HoneypotPresetMetaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.meta = mapped
    }

    /**
     * @param argument Honeypot template custom parameters. See `meta` below.
     */
    @JvmName("hgcfswcdqwvkjinb")
    public suspend fun meta(argument: suspend HoneypotPresetMetaArgsBuilder.() -> Unit) {
        val toBeMapped = HoneypotPresetMetaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.meta = mapped
    }

    /**
     * @param value Unique id of management node
     */
    @JvmName("sumdusavgqtsxccn")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeId = mapped
    }

    /**
     * @param value Honeypot template custom name
     */
    @JvmName("bcgfkjwybjukppar")
    public suspend fun presetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presetName = mapped
    }

    internal fun build(): HoneypotPresetArgs = HoneypotPresetArgs(
        honeypotImageName = honeypotImageName,
        meta = meta,
        nodeId = nodeId,
        presetName = presetName,
    )
}
