@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.kotlin.outputs.HoneypotProbeHoneypotBindList
import com.pulumi.alicloud.threatdetection.kotlin.outputs.HoneypotProbeHoneypotBindList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HoneypotProbe].
 */
@PulumiTagMarker
public class HoneypotProbeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HoneypotProbeArgs = HoneypotProbeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HoneypotProbeArgsBuilder.() -> Unit) {
        val builder = HoneypotProbeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HoneypotProbe {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.HoneypotProbe(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HoneypotProbe(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Honeypot Probe resource.
 * For information about Threat Detection Honeypot Probe and how to use it, see [What is Honeypot Probe](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotprobe).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.HoneypotProbe("default", {
 *     uuid: "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *     probeType: "host_probe",
 *     controlNodeId: "a44e1ab3-6945-444c-889d-5bacee7056e8",
 *     ping: true,
 *     honeypotBindLists: [{
 *         bindPortLists: [{
 *             startPort: 80,
 *             endPort: 80,
 *         }],
 *         honeypotId: "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *     }],
 *     displayName: "apispec",
 *     arp: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.HoneypotProbe("default",
 *     uuid="032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *     probe_type="host_probe",
 *     control_node_id="a44e1ab3-6945-444c-889d-5bacee7056e8",
 *     ping=True,
 *     honeypot_bind_lists=[{
 *         "bind_port_lists": [{
 *             "start_port": 80,
 *             "end_port": 80,
 *         }],
 *         "honeypot_id": "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *     }],
 *     display_name="apispec",
 *     arp=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.HoneypotProbe("default", new()
 *     {
 *         Uuid = "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *         ProbeType = "host_probe",
 *         ControlNodeId = "a44e1ab3-6945-444c-889d-5bacee7056e8",
 *         Ping = true,
 *         HoneypotBindLists = new[]
 *         {
 *             new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListArgs
 *             {
 *                 BindPortLists = new[]
 *                 {
 *                     new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListBindPortListArgs
 *                     {
 *                         StartPort = 80,
 *                         EndPort = 80,
 *                     },
 *                 },
 *                 HoneypotId = "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *             },
 *         },
 *         DisplayName = "apispec",
 *         Arp = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewHoneypotProbe(ctx, "default", &threatdetection.HoneypotProbeArgs{
 * 			Uuid:          pulumi.String("032b618f-b220-4a0d-bd37-fbdc6ef58b6a"),
 * 			ProbeType:     pulumi.String("host_probe"),
 * 			ControlNodeId: pulumi.String("a44e1ab3-6945-444c-889d-5bacee7056e8"),
 * 			Ping:          pulumi.Bool(true),
 * 			HoneypotBindLists: threatdetection.HoneypotProbeHoneypotBindListArray{
 * 				&threatdetection.HoneypotProbeHoneypotBindListArgs{
 * 					BindPortLists: threatdetection.HoneypotProbeHoneypotBindListBindPortListArray{
 * 						&threatdetection.HoneypotProbeHoneypotBindListBindPortListArgs{
 * 							StartPort: pulumi.Int(80),
 * 							EndPort:   pulumi.Int(80),
 * 						},
 * 					},
 * 					HoneypotId: pulumi.String("ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9"),
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("apispec"),
 * 			Arp:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.HoneypotProbe;
 * import com.pulumi.alicloud.threatdetection.HoneypotProbeArgs;
 * import com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new HoneypotProbe("default", HoneypotProbeArgs.builder()
 *             .uuid("032b618f-b220-4a0d-bd37-fbdc6ef58b6a")
 *             .probeType("host_probe")
 *             .controlNodeId("a44e1ab3-6945-444c-889d-5bacee7056e8")
 *             .ping(true)
 *             .honeypotBindLists(HoneypotProbeHoneypotBindListArgs.builder()
 *                 .bindPortLists(HoneypotProbeHoneypotBindListBindPortListArgs.builder()
 *                     .startPort(80)
 *                     .endPort(80)
 *                     .build())
 *                 .honeypotId("ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9")
 *                 .build())
 *             .displayName("apispec")
 *             .arp(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:HoneypotProbe
 *     properties:
 *       uuid: 032b618f-b220-4a0d-bd37-fbdc6ef58b6a
 *       probeType: host_probe
 *       controlNodeId: a44e1ab3-6945-444c-889d-5bacee7056e8
 *       ping: true
 *       honeypotBindLists:
 *         - bindPortLists:
 *             - startPort: 80
 *               endPort: 80
 *           honeypotId: ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9
 *       displayName: apispec
 *       arp: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honeypot Probe can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeypotProbe:HoneypotProbe example <id>
 * ```
 */
public class HoneypotProbe internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.HoneypotProbe,
) : KotlinCustomResource(javaResource, HoneypotProbeMapper) {
    /**
     * ARP spoofing detection.**true**: Enable **false**: Disabled
     */
    public val arp: Output<Boolean>?
        get() = javaResource.arp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the management node.
     */
    public val controlNodeId: Output<String>
        get() = javaResource.controlNodeId().applyValue({ args0 -> args0 })

    /**
     * Probe display name.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Configure the service.See the following `Block HoneypotBindList`.
     */
    public val honeypotBindLists: Output<List<HoneypotProbeHoneypotBindList>>?
        get() = javaResource.honeypotBindLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The first ID of the resource
     */
    public val honeypotProbeId: Output<String>
        get() = javaResource.honeypotProbeId().applyValue({ args0 -> args0 })

    /**
     * Ping scan detection. Value: **true**: Enable **false**: Disabled
     */
    public val ping: Output<Boolean>?
        get() = javaResource.ping().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Probe type, support `host_probe` and `vpc_black_hole_probe`.
     */
    public val probeType: Output<String>
        get() = javaResource.probeType().applyValue({ args0 -> args0 })

    /**
     * The version of the probe.
     */
    public val probeVersion: Output<String>
        get() = javaResource.probeVersion().applyValue({ args0 -> args0 })

    /**
     * The IP address of the proxy.
     */
    public val proxyIp: Output<String>?
        get() = javaResource.proxyIp().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Listen to the IP address list.
     */
    public val serviceIpLists: Output<List<String>>
        get() = javaResource.serviceIpLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The status of the resource
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Machine uuid, **probe_type** is `host_probe`. This value cannot be empty.
     */
    public val uuid: Output<String>?
        get() = javaResource.uuid().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the VPC. **probe_type** is `vpc_black_hole_probe`. This value cannot be empty.
     */
    public val vpcId: Output<String>?
        get() = javaResource.vpcId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object HoneypotProbeMapper : ResourceMapper<HoneypotProbe> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.HoneypotProbe::class == javaResource::class

    override fun map(javaResource: Resource): HoneypotProbe = HoneypotProbe(
        javaResource as
            com.pulumi.alicloud.threatdetection.HoneypotProbe,
    )
}

/**
 * @see [HoneypotProbe].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HoneypotProbe].
 */
public suspend fun honeypotProbe(
    name: String,
    block: suspend HoneypotProbeResourceBuilder.() -> Unit,
): HoneypotProbe {
    val builder = HoneypotProbeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HoneypotProbe].
 * @param name The _unique_ name of the resulting resource.
 */
public fun honeypotProbe(name: String): HoneypotProbe {
    val builder = HoneypotProbeResourceBuilder()
    builder.name(name)
    return builder.build()
}
