@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.HoneypotProbeArgs.builder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.HoneypotProbeHoneypotBindListArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.HoneypotProbeHoneypotBindListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Honeypot Probe resource.
 * For information about Threat Detection Honeypot Probe and how to use it, see [What is Honeypot Probe](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotprobe).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.HoneypotProbe("default", {
 *     uuid: "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *     probeType: "host_probe",
 *     controlNodeId: "a44e1ab3-6945-444c-889d-5bacee7056e8",
 *     ping: true,
 *     honeypotBindLists: [{
 *         bindPortLists: [{
 *             startPort: 80,
 *             endPort: 80,
 *         }],
 *         honeypotId: "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *     }],
 *     displayName: "apispec",
 *     arp: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.HoneypotProbe("default",
 *     uuid="032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *     probe_type="host_probe",
 *     control_node_id="a44e1ab3-6945-444c-889d-5bacee7056e8",
 *     ping=True,
 *     honeypot_bind_lists=[{
 *         "bind_port_lists": [{
 *             "start_port": 80,
 *             "end_port": 80,
 *         }],
 *         "honeypot_id": "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *     }],
 *     display_name="apispec",
 *     arp=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.HoneypotProbe("default", new()
 *     {
 *         Uuid = "032b618f-b220-4a0d-bd37-fbdc6ef58b6a",
 *         ProbeType = "host_probe",
 *         ControlNodeId = "a44e1ab3-6945-444c-889d-5bacee7056e8",
 *         Ping = true,
 *         HoneypotBindLists = new[]
 *         {
 *             new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListArgs
 *             {
 *                 BindPortLists = new[]
 *                 {
 *                     new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListBindPortListArgs
 *                     {
 *                         StartPort = 80,
 *                         EndPort = 80,
 *                     },
 *                 },
 *                 HoneypotId = "ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9",
 *             },
 *         },
 *         DisplayName = "apispec",
 *         Arp = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewHoneypotProbe(ctx, "default", &threatdetection.HoneypotProbeArgs{
 * 			Uuid:          pulumi.String("032b618f-b220-4a0d-bd37-fbdc6ef58b6a"),
 * 			ProbeType:     pulumi.String("host_probe"),
 * 			ControlNodeId: pulumi.String("a44e1ab3-6945-444c-889d-5bacee7056e8"),
 * 			Ping:          pulumi.Bool(true),
 * 			HoneypotBindLists: threatdetection.HoneypotProbeHoneypotBindListArray{
 * 				&threatdetection.HoneypotProbeHoneypotBindListArgs{
 * 					BindPortLists: threatdetection.HoneypotProbeHoneypotBindListBindPortListArray{
 * 						&threatdetection.HoneypotProbeHoneypotBindListBindPortListArgs{
 * 							StartPort: pulumi.Int(80),
 * 							EndPort:   pulumi.Int(80),
 * 						},
 * 					},
 * 					HoneypotId: pulumi.String("ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9"),
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("apispec"),
 * 			Arp:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.HoneypotProbe;
 * import com.pulumi.alicloud.threatdetection.HoneypotProbeArgs;
 * import com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new HoneypotProbe("default", HoneypotProbeArgs.builder()
 *             .uuid("032b618f-b220-4a0d-bd37-fbdc6ef58b6a")
 *             .probeType("host_probe")
 *             .controlNodeId("a44e1ab3-6945-444c-889d-5bacee7056e8")
 *             .ping(true)
 *             .honeypotBindLists(HoneypotProbeHoneypotBindListArgs.builder()
 *                 .bindPortLists(HoneypotProbeHoneypotBindListBindPortListArgs.builder()
 *                     .startPort(80)
 *                     .endPort(80)
 *                     .build())
 *                 .honeypotId("ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9")
 *                 .build())
 *             .displayName("apispec")
 *             .arp(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:HoneypotProbe
 *     properties:
 *       uuid: 032b618f-b220-4a0d-bd37-fbdc6ef58b6a
 *       probeType: host_probe
 *       controlNodeId: a44e1ab3-6945-444c-889d-5bacee7056e8
 *       ping: true
 *       honeypotBindLists:
 *         - bindPortLists:
 *             - startPort: 80
 *               endPort: 80
 *           honeypotId: ede59ccdb1b7a2e21735d4593a6eb5ed31883af320c5ab63ab33818e94307be9
 *       displayName: apispec
 *       arp: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Honeypot Probe can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/honeypotProbe:HoneypotProbe example <id>
 * ```
 * @property arp ARP spoofing detection.**true**: Enable **false**: Disabled
 * @property controlNodeId The ID of the management node.
 * @property displayName Probe display name.
 * @property honeypotBindLists Configure the service.See the following `Block HoneypotBindList`.
 * @property ping Ping scan detection. Value: **true**: Enable **false**: Disabled
 * @property probeType Probe type, support `host_probe` and `vpc_black_hole_probe`.
 * @property probeVersion The version of the probe.
 * @property proxyIp The IP address of the proxy.
 * @property serviceIpLists Listen to the IP address list.
 * @property uuid Machine uuid, **probe_type** is `host_probe`. This value cannot be empty.
 * @property vpcId The ID of the VPC. **probe_type** is `vpc_black_hole_probe`. This value cannot be empty.
 */
public data class HoneypotProbeArgs(
    public val arp: Output<Boolean>? = null,
    public val controlNodeId: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val honeypotBindLists: Output<List<HoneypotProbeHoneypotBindListArgs>>? = null,
    public val ping: Output<Boolean>? = null,
    public val probeType: Output<String>? = null,
    public val probeVersion: Output<String>? = null,
    public val proxyIp: Output<String>? = null,
    public val serviceIpLists: Output<List<String>>? = null,
    public val uuid: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.HoneypotProbeArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.HoneypotProbeArgs =
        com.pulumi.alicloud.threatdetection.HoneypotProbeArgs.builder()
            .arp(arp?.applyValue({ args0 -> args0 }))
            .controlNodeId(controlNodeId?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .honeypotBindLists(
                honeypotBindLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ping(ping?.applyValue({ args0 -> args0 }))
            .probeType(probeType?.applyValue({ args0 -> args0 }))
            .probeVersion(probeVersion?.applyValue({ args0 -> args0 }))
            .proxyIp(proxyIp?.applyValue({ args0 -> args0 }))
            .serviceIpLists(serviceIpLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .uuid(uuid?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoneypotProbeArgs].
 */
@PulumiTagMarker
public class HoneypotProbeArgsBuilder internal constructor() {
    private var arp: Output<Boolean>? = null

    private var controlNodeId: Output<String>? = null

    private var displayName: Output<String>? = null

    private var honeypotBindLists: Output<List<HoneypotProbeHoneypotBindListArgs>>? = null

    private var ping: Output<Boolean>? = null

    private var probeType: Output<String>? = null

    private var probeVersion: Output<String>? = null

    private var proxyIp: Output<String>? = null

    private var serviceIpLists: Output<List<String>>? = null

    private var uuid: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value ARP spoofing detection.**true**: Enable **false**: Disabled
     */
    @JvmName("rhvwbictplxqjhdq")
    public suspend fun arp(`value`: Output<Boolean>) {
        this.arp = value
    }

    /**
     * @param value The ID of the management node.
     */
    @JvmName("oljnuuudcjbtkibq")
    public suspend fun controlNodeId(`value`: Output<String>) {
        this.controlNodeId = value
    }

    /**
     * @param value Probe display name.
     */
    @JvmName("wnousebjasgiqsjo")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("yfknibmhvbrdrvip")
    public suspend fun honeypotBindLists(`value`: Output<List<HoneypotProbeHoneypotBindListArgs>>) {
        this.honeypotBindLists = value
    }

    @JvmName("dcvtermgjcsnohjs")
    public suspend fun honeypotBindLists(vararg values: Output<HoneypotProbeHoneypotBindListArgs>) {
        this.honeypotBindLists = Output.all(values.asList())
    }

    /**
     * @param values Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("vfsqvislxklpqgde")
    public suspend fun honeypotBindLists(values: List<Output<HoneypotProbeHoneypotBindListArgs>>) {
        this.honeypotBindLists = Output.all(values)
    }

    /**
     * @param value Ping scan detection. Value: **true**: Enable **false**: Disabled
     */
    @JvmName("fcfanrfbtceanlne")
    public suspend fun ping(`value`: Output<Boolean>) {
        this.ping = value
    }

    /**
     * @param value Probe type, support `host_probe` and `vpc_black_hole_probe`.
     */
    @JvmName("oaqgtopsddlueajs")
    public suspend fun probeType(`value`: Output<String>) {
        this.probeType = value
    }

    /**
     * @param value The version of the probe.
     */
    @JvmName("nuvkthxqkmbjuhau")
    public suspend fun probeVersion(`value`: Output<String>) {
        this.probeVersion = value
    }

    /**
     * @param value The IP address of the proxy.
     */
    @JvmName("lcjjdktltphaeami")
    public suspend fun proxyIp(`value`: Output<String>) {
        this.proxyIp = value
    }

    /**
     * @param value Listen to the IP address list.
     */
    @JvmName("eyslahpvvucesegt")
    public suspend fun serviceIpLists(`value`: Output<List<String>>) {
        this.serviceIpLists = value
    }

    @JvmName("kposrnanpsnhqjwd")
    public suspend fun serviceIpLists(vararg values: Output<String>) {
        this.serviceIpLists = Output.all(values.asList())
    }

    /**
     * @param values Listen to the IP address list.
     */
    @JvmName("dyfbmhmewjdtaguc")
    public suspend fun serviceIpLists(values: List<Output<String>>) {
        this.serviceIpLists = Output.all(values)
    }

    /**
     * @param value Machine uuid, **probe_type** is `host_probe`. This value cannot be empty.
     */
    @JvmName("yqbxiwjuqxnslnwp")
    public suspend fun uuid(`value`: Output<String>) {
        this.uuid = value
    }

    /**
     * @param value The ID of the VPC. **probe_type** is `vpc_black_hole_probe`. This value cannot be empty.
     */
    @JvmName("ftgabwkiusimwdse")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value ARP spoofing detection.**true**: Enable **false**: Disabled
     */
    @JvmName("xvoqchcgqlfbymcn")
    public suspend fun arp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arp = mapped
    }

    /**
     * @param value The ID of the management node.
     */
    @JvmName("apyubravifndyvvc")
    public suspend fun controlNodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlNodeId = mapped
    }

    /**
     * @param value Probe display name.
     */
    @JvmName("lrtxajdpeqbebbpv")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("tattsuityhejdpbl")
    public suspend fun honeypotBindLists(`value`: List<HoneypotProbeHoneypotBindListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeypotBindLists = mapped
    }

    /**
     * @param argument Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("qwpdxnhrmxudbaew")
    public suspend fun honeypotBindLists(argument: List<suspend HoneypotProbeHoneypotBindListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HoneypotProbeHoneypotBindListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.honeypotBindLists = mapped
    }

    /**
     * @param argument Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("rvyqkxivscfcsqke")
    public suspend fun honeypotBindLists(vararg argument: suspend HoneypotProbeHoneypotBindListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HoneypotProbeHoneypotBindListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.honeypotBindLists = mapped
    }

    /**
     * @param argument Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("xieagohrdcvyyvex")
    public suspend fun honeypotBindLists(argument: suspend HoneypotProbeHoneypotBindListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HoneypotProbeHoneypotBindListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.honeypotBindLists = mapped
    }

    /**
     * @param values Configure the service.See the following `Block HoneypotBindList`.
     */
    @JvmName("tudjjhmmfactfkwr")
    public suspend fun honeypotBindLists(vararg values: HoneypotProbeHoneypotBindListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.honeypotBindLists = mapped
    }

    /**
     * @param value Ping scan detection. Value: **true**: Enable **false**: Disabled
     */
    @JvmName("iibjygpdophquxmh")
    public suspend fun ping(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ping = mapped
    }

    /**
     * @param value Probe type, support `host_probe` and `vpc_black_hole_probe`.
     */
    @JvmName("vrkaypccsqrbpxwi")
    public suspend fun probeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeType = mapped
    }

    /**
     * @param value The version of the probe.
     */
    @JvmName("jwlafiqfnjdktqte")
    public suspend fun probeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeVersion = mapped
    }

    /**
     * @param value The IP address of the proxy.
     */
    @JvmName("wkxyjgvqanboxogc")
    public suspend fun proxyIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proxyIp = mapped
    }

    /**
     * @param value Listen to the IP address list.
     */
    @JvmName("uuyrmyagulujcadx")
    public suspend fun serviceIpLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIpLists = mapped
    }

    /**
     * @param values Listen to the IP address list.
     */
    @JvmName("dshcpirjtvkrkhpk")
    public suspend fun serviceIpLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceIpLists = mapped
    }

    /**
     * @param value Machine uuid, **probe_type** is `host_probe`. This value cannot be empty.
     */
    @JvmName("khimyuaonbjtpytp")
    public suspend fun uuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuid = mapped
    }

    /**
     * @param value The ID of the VPC. **probe_type** is `vpc_black_hole_probe`. This value cannot be empty.
     */
    @JvmName("emtycrneyqhfukcn")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): HoneypotProbeArgs = HoneypotProbeArgs(
        arp = arp,
        controlNodeId = controlNodeId,
        displayName = displayName,
        honeypotBindLists = honeypotBindLists,
        ping = ping,
        probeType = probeType,
        probeVersion = probeVersion,
        proxyIp = proxyIp,
        serviceIpLists = serviceIpLists,
        uuid = uuid,
        vpcId = vpcId,
    )
}
