@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImageEventOperation].
 */
@PulumiTagMarker
public class ImageEventOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageEventOperationArgs = ImageEventOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageEventOperationArgsBuilder.() -> Unit) {
        val builder = ImageEventOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImageEventOperation {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.ImageEventOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ImageEventOperation(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Image Event Operation resource. Image Event Operation.
 * For information about Threat Detection Image Event Operation and how to use it, see [What is Image Event Operation](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-addimageeventoperation).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ImageEventOperation("default", {
 *     eventType: "maliciousFile",
 *     operationCode: "whitelist",
 *     eventKey: "alibabacloud_ak",
 *     scenarios: `{
 *   "type":"default",
 *   "value":""
 * }
 * `,
 *     eventName: "阿里云AK",
 *     conditions: `[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ImageEventOperation("default",
 *     event_type="maliciousFile",
 *     operation_code="whitelist",
 *     event_key="alibabacloud_ak",
 *     scenarios="""{
 *   "type":"default",
 *   "value":""
 * }
 * """,
 *     event_name="阿里云AK",
 *     conditions="""[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ImageEventOperation("default", new()
 *     {
 *         EventType = "maliciousFile",
 *         OperationCode = "whitelist",
 *         EventKey = "alibabacloud_ak",
 *         Scenarios = @"{
 *   ""type"":""default"",
 *   ""value"":""""
 * }
 * ",
 *         EventName = "阿里云AK",
 *         Conditions = @"[
 *   {
 *       ""condition"":""MD5"",
 *       ""type"":""equals"",
 *       ""value"":""0083a31cc0083a31ccf7c10367a6e783e""
 *   }
 * ]
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewImageEventOperation(ctx, "default", &threatdetection.ImageEventOperationArgs{
 * 			EventType:     pulumi.String("maliciousFile"),
 * 			OperationCode: pulumi.String("whitelist"),
 * 			EventKey:      pulumi.String("alibabacloud_ak"),
 * 			Scenarios:     pulumi.String("{\n  \"type\":\"default\",\n  \"value\":\"\"\n}\n"),
 * 			EventName:     pulumi.String("阿里云AK"),
 * 			Conditions: pulumi.String(`[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ImageEventOperation;
 * import com.pulumi.alicloud.threatdetection.ImageEventOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ImageEventOperation("default", ImageEventOperationArgs.builder()
 *             .eventType("maliciousFile")
 *             .operationCode("whitelist")
 *             .eventKey("alibabacloud_ak")
 *             .scenarios("""
 * {
 *   "type":"default",
 *   "value":""
 * }
 *             """)
 *             .eventName("阿里云AK")
 *             .conditions("""
 * [
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ImageEventOperation
 *     properties:
 *       eventType: maliciousFile
 *       operationCode: whitelist
 *       eventKey: alibabacloud_ak
 *       scenarios: |
 *         {
 *           "type":"default",
 *           "value":""
 *         }
 *       eventName: 阿里云AK
 *       conditions: |
 *         [
 *           {
 *               "condition":"MD5",
 *               "type":"equals",
 *               "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *           }
 *         ]
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Image Event Operation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/imageEventOperation:ImageEventOperation example <id>
 * ```
 */
public class ImageEventOperation internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.ImageEventOperation,
) : KotlinCustomResource(javaResource, ImageEventOperationMapper) {
    /**
     * Event Conditions.
     */
    public val conditions: Output<String>?
        get() = javaResource.conditions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Image Event Key.
     */
    public val eventKey: Output<String>?
        get() = javaResource.eventKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Image Event Name.
     */
    public val eventName: Output<String>?
        get() = javaResource.eventName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Image Event Type.
     */
    public val eventType: Output<String>
        get() = javaResource.eventType().applyValue({ args0 -> args0 })

    /**
     * Event Operation Code.
     */
    public val operationCode: Output<String>?
        get() = javaResource.operationCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Event Scenarios.
     */
    public val scenarios: Output<String>?
        get() = javaResource.scenarios().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ImageEventOperationMapper : ResourceMapper<ImageEventOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.ImageEventOperation::class == javaResource::class

    override fun map(javaResource: Resource): ImageEventOperation = ImageEventOperation(
        javaResource
            as com.pulumi.alicloud.threatdetection.ImageEventOperation,
    )
}

/**
 * @see [ImageEventOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageEventOperation].
 */
public suspend fun imageEventOperation(
    name: String,
    block: suspend ImageEventOperationResourceBuilder.() -> Unit,
): ImageEventOperation {
    val builder = ImageEventOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageEventOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageEventOperation(name: String): ImageEventOperation {
    val builder = ImageEventOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
