@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.ImageEventOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Image Event Operation resource. Image Event Operation.
 * For information about Threat Detection Image Event Operation and how to use it, see [What is Image Event Operation](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-addimageeventoperation).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.ImageEventOperation("default", {
 *     eventType: "maliciousFile",
 *     operationCode: "whitelist",
 *     eventKey: "alibabacloud_ak",
 *     scenarios: `{
 *   "type":"default",
 *   "value":""
 * }
 * `,
 *     eventName: "阿里云AK",
 *     conditions: `[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.ImageEventOperation("default",
 *     event_type="maliciousFile",
 *     operation_code="whitelist",
 *     event_key="alibabacloud_ak",
 *     scenarios="""{
 *   "type":"default",
 *   "value":""
 * }
 * """,
 *     event_name="阿里云AK",
 *     conditions="""[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.ImageEventOperation("default", new()
 *     {
 *         EventType = "maliciousFile",
 *         OperationCode = "whitelist",
 *         EventKey = "alibabacloud_ak",
 *         Scenarios = @"{
 *   ""type"":""default"",
 *   ""value"":""""
 * }
 * ",
 *         EventName = "阿里云AK",
 *         Conditions = @"[
 *   {
 *       ""condition"":""MD5"",
 *       ""type"":""equals"",
 *       ""value"":""0083a31cc0083a31ccf7c10367a6e783e""
 *   }
 * ]
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewImageEventOperation(ctx, "default", &threatdetection.ImageEventOperationArgs{
 * 			EventType:     pulumi.String("maliciousFile"),
 * 			OperationCode: pulumi.String("whitelist"),
 * 			EventKey:      pulumi.String("alibabacloud_ak"),
 * 			Scenarios:     pulumi.String("{\n  \"type\":\"default\",\n  \"value\":\"\"\n}\n"),
 * 			EventName:     pulumi.String("阿里云AK"),
 * 			Conditions: pulumi.String(`[
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ImageEventOperation;
 * import com.pulumi.alicloud.threatdetection.ImageEventOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ImageEventOperation("default", ImageEventOperationArgs.builder()
 *             .eventType("maliciousFile")
 *             .operationCode("whitelist")
 *             .eventKey("alibabacloud_ak")
 *             .scenarios("""
 * {
 *   "type":"default",
 *   "value":""
 * }
 *             """)
 *             .eventName("阿里云AK")
 *             .conditions("""
 * [
 *   {
 *       "condition":"MD5",
 *       "type":"equals",
 *       "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *   }
 * ]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:ImageEventOperation
 *     properties:
 *       eventType: maliciousFile
 *       operationCode: whitelist
 *       eventKey: alibabacloud_ak
 *       scenarios: |
 *         {
 *           "type":"default",
 *           "value":""
 *         }
 *       eventName: 阿里云AK
 *       conditions: |
 *         [
 *           {
 *               "condition":"MD5",
 *               "type":"equals",
 *               "value":"0083a31cc0083a31ccf7c10367a6e783e"
 *           }
 *         ]
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Image Event Operation can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/imageEventOperation:ImageEventOperation example <id>
 * ```
 * @property conditions Event Conditions.
 * @property eventKey Image Event Key.
 * @property eventName Image Event Name.
 * @property eventType Image Event Type.
 * @property operationCode Event Operation Code.
 * @property scenarios Event Scenarios.
 */
public data class ImageEventOperationArgs(
    public val conditions: Output<String>? = null,
    public val eventKey: Output<String>? = null,
    public val eventName: Output<String>? = null,
    public val eventType: Output<String>? = null,
    public val operationCode: Output<String>? = null,
    public val scenarios: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.ImageEventOperationArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.ImageEventOperationArgs =
        com.pulumi.alicloud.threatdetection.ImageEventOperationArgs.builder()
            .conditions(conditions?.applyValue({ args0 -> args0 }))
            .eventKey(eventKey?.applyValue({ args0 -> args0 }))
            .eventName(eventName?.applyValue({ args0 -> args0 }))
            .eventType(eventType?.applyValue({ args0 -> args0 }))
            .operationCode(operationCode?.applyValue({ args0 -> args0 }))
            .scenarios(scenarios?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageEventOperationArgs].
 */
@PulumiTagMarker
public class ImageEventOperationArgsBuilder internal constructor() {
    private var conditions: Output<String>? = null

    private var eventKey: Output<String>? = null

    private var eventName: Output<String>? = null

    private var eventType: Output<String>? = null

    private var operationCode: Output<String>? = null

    private var scenarios: Output<String>? = null

    /**
     * @param value Event Conditions.
     */
    @JvmName("mbhkmaindewhvsin")
    public suspend fun conditions(`value`: Output<String>) {
        this.conditions = value
    }

    /**
     * @param value Image Event Key.
     */
    @JvmName("bwglyektcwdmrbsp")
    public suspend fun eventKey(`value`: Output<String>) {
        this.eventKey = value
    }

    /**
     * @param value Image Event Name.
     */
    @JvmName("xnabrpaykewpkkww")
    public suspend fun eventName(`value`: Output<String>) {
        this.eventName = value
    }

    /**
     * @param value Image Event Type.
     */
    @JvmName("wfjuowgpeblvjfvu")
    public suspend fun eventType(`value`: Output<String>) {
        this.eventType = value
    }

    /**
     * @param value Event Operation Code.
     */
    @JvmName("pojfiyumjnwhumfm")
    public suspend fun operationCode(`value`: Output<String>) {
        this.operationCode = value
    }

    /**
     * @param value Event Scenarios.
     */
    @JvmName("grfdveeunbasyoss")
    public suspend fun scenarios(`value`: Output<String>) {
        this.scenarios = value
    }

    /**
     * @param value Event Conditions.
     */
    @JvmName("gmawhldycdstdjqc")
    public suspend fun conditions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Image Event Key.
     */
    @JvmName("lyqduabyehvwyryr")
    public suspend fun eventKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventKey = mapped
    }

    /**
     * @param value Image Event Name.
     */
    @JvmName("mxopepyqyosagcin")
    public suspend fun eventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value Image Event Type.
     */
    @JvmName("pbwqbxnapaiuxxok")
    public suspend fun eventType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param value Event Operation Code.
     */
    @JvmName("gufqtmhnrekrbyar")
    public suspend fun operationCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operationCode = mapped
    }

    /**
     * @param value Event Scenarios.
     */
    @JvmName("eoqhyihypxqfmstb")
    public suspend fun scenarios(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scenarios = mapped
    }

    internal fun build(): ImageEventOperationArgs = ImageEventOperationArgs(
        conditions = conditions,
        eventKey = eventKey,
        eventName = eventName,
        eventType = eventType,
        operationCode = operationCode,
        scenarios = scenarios,
    )
}
