@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.threatdetection.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Threat Detection Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Number of servers.
     */
    public val buyNumber: Output<String>?
        get() = javaResource.buyNumber().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    @Deprecated(
        message = """
  Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image
      security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only
      multiples of 20 can be filled in.
  """,
    )
    public val containerImageScan: Output<String>?
        get() = javaResource.containerImageScan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    public val containerImageScanNew: Output<String>?
        get() = javaResource.containerImageScanNew().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Number of cloud honeypot licenses. Interval type, value interval:[20,500].
     * > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
     */
    public val honeypot: Output<String>?
        get() = javaResource.honeypot().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Cloud honeypot. Value:
     * - 1: Yes.
     * - 2: No.
     */
    public val honeypotSwitch: Output<String>
        get() = javaResource.honeypotSwitch().applyValue({ args0 -> args0 })

    /**
     * Change configuration type, value
     * - Upgrade: Upgrade.
     * - Downgrade: Downgrade.
     */
    public val modifyType: Output<String>?
        get() = javaResource.modifyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The payment type of the resource.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
     * > **NOTE:**  must be set when creating a prepaid instance.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of application protection licenses. Interval type, value interval:[1,100000000].
     */
    public val raspCount: Output<String>?
        get() = javaResource.raspCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Automatic renewal cycle, in months.
     * > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
     */
    public val renewPeriod: Output<Int>
        get() = javaResource.renewPeriod().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal period unit, value:
     * - M: month.
     * - Y: years.
     * > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
     */
    public val renewalPeriodUnit: Output<String>
        get() = javaResource.renewalPeriodUnit().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal status, default ManualRenewal, valid values:
     * - AutoRenewal: automatic renewal.
     * - ManualRenewal: manual renewal.
     */
    public val renewalStatus: Output<String>?
        get() = javaResource.renewalStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    public val sasAntiRansomware: Output<String>?
        get() = javaResource.sasAntiRansomware().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
     * > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
     */
    public val sasCspm: Output<String>?
        get() = javaResource.sasCspm().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Cloud platform configuration check switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    public val sasCspmSwitch: Output<String>
        get() = javaResource.sasCspmSwitch().applyValue({ args0 -> args0 })

    /**
     * Security screen. Value:
     * - true: Yes.
     * - false: No.
     */
    public val sasSc: Output<Boolean>?
        get() = javaResource.sasSc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
     * > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    public val sasSdk: Output<String>?
        get() = javaResource.sasSdk().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Malicious file detection SDK.
     */
    public val sasSdkSwitch: Output<String>
        get() = javaResource.sasSdkSwitch().applyValue({ args0 -> args0 })

    /**
     * Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    public val sasSlsStorage: Output<String>?
        get() = javaResource.sasSlsStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Web tamper-proof switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    public val sasWebguardBoolean: Output<String>
        get() = javaResource.sasWebguardBoolean().applyValue({ args0 -> args0 })

    /**
     * Tamper-proof authorization number. Value:
     * - 0: No
     * - 1: Yes.
     */
    public val sasWebguardOrderNum: Output<String>?
        get() = javaResource.sasWebguardOrderNum().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    public val threatAnalysis: Output<String>?
        get() = javaResource.threatAnalysis().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Threat analysis. Value:
     * - 0: No.
     * - 1: Yes.
     */
    public val threatAnalysisSwitch: Output<String>
        get() = javaResource.threatAnalysisSwitch().applyValue({ args0 -> args0 })

    /**
     * Number of cores.
     */
    public val vCore: Output<String>?
        get() = javaResource.vCore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Select the security center version. Value:
     * - level7: Antivirus Edition.
     * - level3: Premium version.
     * - level2: Enterprise Edition.
     * - level8: Ultimate.
     * - level10: Purchase value-added services only.
     */
    public val versionCode: Output<String>
        get() = javaResource.versionCode().applyValue({ args0 -> args0 })

    /**
     * Vulnerability repair times, interval type, value range:[20,100000000].
     * > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
     */
    public val vulCount: Output<String>?
        get() = javaResource.vulCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Vulnerability fix switch. Value:
     * - 0: No.
     * - 1: Yes.
     * > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
     */
    public val vulSwitch: Output<String>
        get() = javaResource.vulSwitch().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.threatdetection.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
