@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Threat Detection Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/instance:Instance example <id>
 * ```
 * @property buyNumber Number of servers.
 * @property containerImageScan Container Image security scan. Interval type, value interval:[0,200000].
 * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
 * @property containerImageScanNew Container Image security scan. Interval type, value interval:[0,200000].
 * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
 * @property honeypot Number of cloud honeypot licenses. Interval type, value interval:[20,500].
 * > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
 * @property honeypotSwitch Cloud honeypot. Value:
 * - 1: Yes.
 * - 2: No.
 * @property modifyType Change configuration type, value
 * - Upgrade: Upgrade.
 * - Downgrade: Downgrade.
 * @property paymentType The payment type of the resource.
 * @property period Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
 * > **NOTE:**  must be set when creating a prepaid instance.
 * @property raspCount Number of application protection licenses. Interval type, value interval:[1,100000000].
 * @property renewPeriod Automatic renewal cycle, in months.
 * > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
 * @property renewalPeriodUnit Automatic renewal period unit, value:
 * - M: month.
 * - Y: years.
 * > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
 * @property renewalStatus Automatic renewal status, default ManualRenewal, valid values:
 * - AutoRenewal: automatic renewal.
 * - ManualRenewal: manual renewal.
 * @property sasAntiRansomware Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
 * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
 * @property sasCspm Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
 * > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
 * @property sasCspmSwitch Cloud platform configuration check switch. Value:
 * - 0: No.
 * - 1: Yes.
 * @property sasSc Security screen. Value:
 * - true: Yes.
 * - false: No.
 * @property sasSdk Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
 * > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
 * @property sasSdkSwitch Malicious file detection SDK.
 * @property sasSlsStorage Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
 * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
 * @property sasWebguardBoolean Web tamper-proof switch. Value:
 * - 0: No.
 * - 1: Yes.
 * @property sasWebguardOrderNum Tamper-proof authorization number. Value:
 * - 0: No
 * - 1: Yes.
 * @property threatAnalysis Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
 * > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
 * @property threatAnalysisSwitch Threat analysis. Value:
 * - 0: No.
 * - 1: Yes.
 * @property vCore Number of cores.
 * @property versionCode Select the security center version. Value:
 * - level7: Antivirus Edition.
 * - level3: Premium version.
 * - level2: Enterprise Edition.
 * - level8: Ultimate.
 * - level10: Purchase value-added services only.
 * @property vulCount Vulnerability repair times, interval type, value range:[20,100000000].
 * > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
 * @property vulSwitch Vulnerability fix switch. Value:
 * - 0: No.
 * - 1: Yes.
 * > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
 */
public data class InstanceArgs(
    public val buyNumber: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image
      security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only
      multiples of 20 can be filled in.
  """,
    )
    public val containerImageScan: Output<String>? = null,
    public val containerImageScanNew: Output<String>? = null,
    public val honeypot: Output<String>? = null,
    public val honeypotSwitch: Output<String>? = null,
    public val modifyType: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val raspCount: Output<String>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalPeriodUnit: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val sasAntiRansomware: Output<String>? = null,
    public val sasCspm: Output<String>? = null,
    public val sasCspmSwitch: Output<String>? = null,
    public val sasSc: Output<Boolean>? = null,
    public val sasSdk: Output<String>? = null,
    public val sasSdkSwitch: Output<String>? = null,
    public val sasSlsStorage: Output<String>? = null,
    public val sasWebguardBoolean: Output<String>? = null,
    public val sasWebguardOrderNum: Output<String>? = null,
    public val threatAnalysis: Output<String>? = null,
    public val threatAnalysisSwitch: Output<String>? = null,
    public val vCore: Output<String>? = null,
    public val versionCode: Output<String>? = null,
    public val vulCount: Output<String>? = null,
    public val vulSwitch: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.InstanceArgs =
        com.pulumi.alicloud.threatdetection.InstanceArgs.builder()
            .buyNumber(buyNumber?.applyValue({ args0 -> args0 }))
            .containerImageScan(containerImageScan?.applyValue({ args0 -> args0 }))
            .containerImageScanNew(containerImageScanNew?.applyValue({ args0 -> args0 }))
            .honeypot(honeypot?.applyValue({ args0 -> args0 }))
            .honeypotSwitch(honeypotSwitch?.applyValue({ args0 -> args0 }))
            .modifyType(modifyType?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .raspCount(raspCount?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalPeriodUnit(renewalPeriodUnit?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .sasAntiRansomware(sasAntiRansomware?.applyValue({ args0 -> args0 }))
            .sasCspm(sasCspm?.applyValue({ args0 -> args0 }))
            .sasCspmSwitch(sasCspmSwitch?.applyValue({ args0 -> args0 }))
            .sasSc(sasSc?.applyValue({ args0 -> args0 }))
            .sasSdk(sasSdk?.applyValue({ args0 -> args0 }))
            .sasSdkSwitch(sasSdkSwitch?.applyValue({ args0 -> args0 }))
            .sasSlsStorage(sasSlsStorage?.applyValue({ args0 -> args0 }))
            .sasWebguardBoolean(sasWebguardBoolean?.applyValue({ args0 -> args0 }))
            .sasWebguardOrderNum(sasWebguardOrderNum?.applyValue({ args0 -> args0 }))
            .threatAnalysis(threatAnalysis?.applyValue({ args0 -> args0 }))
            .threatAnalysisSwitch(threatAnalysisSwitch?.applyValue({ args0 -> args0 }))
            .vCore(vCore?.applyValue({ args0 -> args0 }))
            .versionCode(versionCode?.applyValue({ args0 -> args0 }))
            .vulCount(vulCount?.applyValue({ args0 -> args0 }))
            .vulSwitch(vulSwitch?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var buyNumber: Output<String>? = null

    private var containerImageScan: Output<String>? = null

    private var containerImageScanNew: Output<String>? = null

    private var honeypot: Output<String>? = null

    private var honeypotSwitch: Output<String>? = null

    private var modifyType: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var raspCount: Output<String>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalPeriodUnit: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var sasAntiRansomware: Output<String>? = null

    private var sasCspm: Output<String>? = null

    private var sasCspmSwitch: Output<String>? = null

    private var sasSc: Output<Boolean>? = null

    private var sasSdk: Output<String>? = null

    private var sasSdkSwitch: Output<String>? = null

    private var sasSlsStorage: Output<String>? = null

    private var sasWebguardBoolean: Output<String>? = null

    private var sasWebguardOrderNum: Output<String>? = null

    private var threatAnalysis: Output<String>? = null

    private var threatAnalysisSwitch: Output<String>? = null

    private var vCore: Output<String>? = null

    private var versionCode: Output<String>? = null

    private var vulCount: Output<String>? = null

    private var vulSwitch: Output<String>? = null

    /**
     * @param value Number of servers.
     */
    @JvmName("huvqyclygqlcsccv")
    public suspend fun buyNumber(`value`: Output<String>) {
        this.buyNumber = value
    }

    /**
     * @param value Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    @Deprecated(
        message = """
  Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image
      security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only
      multiples of 20 can be filled in.
  """,
    )
    @JvmName("qlnfwyvggftmccml")
    public suspend fun containerImageScan(`value`: Output<String>) {
        this.containerImageScan = value
    }

    /**
     * @param value Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    @JvmName("afukpajivkddpiss")
    public suspend fun containerImageScanNew(`value`: Output<String>) {
        this.containerImageScanNew = value
    }

    /**
     * @param value Number of cloud honeypot licenses. Interval type, value interval:[20,500].
     * > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
     */
    @JvmName("hleyqvflpnwhswjp")
    public suspend fun honeypot(`value`: Output<String>) {
        this.honeypot = value
    }

    /**
     * @param value Cloud honeypot. Value:
     * - 1: Yes.
     * - 2: No.
     */
    @JvmName("gtkmchxaswqcdakb")
    public suspend fun honeypotSwitch(`value`: Output<String>) {
        this.honeypotSwitch = value
    }

    /**
     * @param value Change configuration type, value
     * - Upgrade: Upgrade.
     * - Downgrade: Downgrade.
     */
    @JvmName("dihfmgbriedrsybx")
    public suspend fun modifyType(`value`: Output<String>) {
        this.modifyType = value
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("qcwcvhucqteubgob")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
     * > **NOTE:**  must be set when creating a prepaid instance.
     */
    @JvmName("crrmpkunfgutkirx")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Number of application protection licenses. Interval type, value interval:[1,100000000].
     */
    @JvmName("fmkdccssuxymmspm")
    public suspend fun raspCount(`value`: Output<String>) {
        this.raspCount = value
    }

    /**
     * @param value Automatic renewal cycle, in months.
     * > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
     */
    @JvmName("jbukjxnjeveawccb")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Automatic renewal period unit, value:
     * - M: month.
     * - Y: years.
     * > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
     */
    @JvmName("tbesnnbjcsyjfxvh")
    public suspend fun renewalPeriodUnit(`value`: Output<String>) {
        this.renewalPeriodUnit = value
    }

    /**
     * @param value Automatic renewal status, default ManualRenewal, valid values:
     * - AutoRenewal: automatic renewal.
     * - ManualRenewal: manual renewal.
     */
    @JvmName("lgjglryfohoxpbxj")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("mbvrcebqucxhugaf")
    public suspend fun sasAntiRansomware(`value`: Output<String>) {
        this.sasAntiRansomware = value
    }

    /**
     * @param value Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
     * > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
     */
    @JvmName("idqlvijqvbfqpoxo")
    public suspend fun sasCspm(`value`: Output<String>) {
        this.sasCspm = value
    }

    /**
     * @param value Cloud platform configuration check switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("wsdqyhccrohjiyej")
    public suspend fun sasCspmSwitch(`value`: Output<String>) {
        this.sasCspmSwitch = value
    }

    /**
     * @param value Security screen. Value:
     * - true: Yes.
     * - false: No.
     */
    @JvmName("awoyqthprdxbehqp")
    public suspend fun sasSc(`value`: Output<Boolean>) {
        this.sasSc = value
    }

    /**
     * @param value Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
     * > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("eokbuhedfxcsmrcg")
    public suspend fun sasSdk(`value`: Output<String>) {
        this.sasSdk = value
    }

    /**
     * @param value Malicious file detection SDK.
     */
    @JvmName("bgxlcnsvfsmjeohn")
    public suspend fun sasSdkSwitch(`value`: Output<String>) {
        this.sasSdkSwitch = value
    }

    /**
     * @param value Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("poxdafiyftcmmapr")
    public suspend fun sasSlsStorage(`value`: Output<String>) {
        this.sasSlsStorage = value
    }

    /**
     * @param value Web tamper-proof switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("rcqjfxtxbooiwjyf")
    public suspend fun sasWebguardBoolean(`value`: Output<String>) {
        this.sasWebguardBoolean = value
    }

    /**
     * @param value Tamper-proof authorization number. Value:
     * - 0: No
     * - 1: Yes.
     */
    @JvmName("fyavvewxpokqppqv")
    public suspend fun sasWebguardOrderNum(`value`: Output<String>) {
        this.sasWebguardOrderNum = value
    }

    /**
     * @param value Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("jwwacgovvqqjyffs")
    public suspend fun threatAnalysis(`value`: Output<String>) {
        this.threatAnalysis = value
    }

    /**
     * @param value Threat analysis. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("bxmqgqwuvhmnnamf")
    public suspend fun threatAnalysisSwitch(`value`: Output<String>) {
        this.threatAnalysisSwitch = value
    }

    /**
     * @param value Number of cores.
     */
    @JvmName("dgtqskjlccvanxyb")
    public suspend fun vCore(`value`: Output<String>) {
        this.vCore = value
    }

    /**
     * @param value Select the security center version. Value:
     * - level7: Antivirus Edition.
     * - level3: Premium version.
     * - level2: Enterprise Edition.
     * - level8: Ultimate.
     * - level10: Purchase value-added services only.
     */
    @JvmName("frajiujcfxpoirjs")
    public suspend fun versionCode(`value`: Output<String>) {
        this.versionCode = value
    }

    /**
     * @param value Vulnerability repair times, interval type, value range:[20,100000000].
     * > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
     */
    @JvmName("qtdvuujbpjlqmgyc")
    public suspend fun vulCount(`value`: Output<String>) {
        this.vulCount = value
    }

    /**
     * @param value Vulnerability fix switch. Value:
     * - 0: No.
     * - 1: Yes.
     * > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
     */
    @JvmName("mcmkchqrrwudwphg")
    public suspend fun vulSwitch(`value`: Output<String>) {
        this.vulSwitch = value
    }

    /**
     * @param value Number of servers.
     */
    @JvmName("lueysgfctatekgyq")
    public suspend fun buyNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buyNumber = mapped
    }

    /**
     * @param value Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    @Deprecated(
        message = """
  Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image
      security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only
      multiples of 20 can be filled in.
  """,
    )
    @JvmName("pscdjehnjlmllgnd")
    public suspend fun containerImageScan(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerImageScan = mapped
    }

    /**
     * @param value Container Image security scan. Interval type, value interval:[0,200000].
     * > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
     */
    @JvmName("mjwridcwqotxcgog")
    public suspend fun containerImageScanNew(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerImageScanNew = mapped
    }

    /**
     * @param value Number of cloud honeypot licenses. Interval type, value interval:[20,500].
     * > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
     */
    @JvmName("ghojbgqfbcjbrarn")
    public suspend fun honeypot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeypot = mapped
    }

    /**
     * @param value Cloud honeypot. Value:
     * - 1: Yes.
     * - 2: No.
     */
    @JvmName("hvkghuidqshognfq")
    public suspend fun honeypotSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeypotSwitch = mapped
    }

    /**
     * @param value Change configuration type, value
     * - Upgrade: Upgrade.
     * - Downgrade: Downgrade.
     */
    @JvmName("aecuadrmxfseteev")
    public suspend fun modifyType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifyType = mapped
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("wxkaydirtybhrmkp")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
     * > **NOTE:**  must be set when creating a prepaid instance.
     */
    @JvmName("nyjkxysyusbkxkua")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Number of application protection licenses. Interval type, value interval:[1,100000000].
     */
    @JvmName("uygxufxfrcfutrfi")
    public suspend fun raspCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raspCount = mapped
    }

    /**
     * @param value Automatic renewal cycle, in months.
     * > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
     */
    @JvmName("kewhmtjhinanbgto")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Automatic renewal period unit, value:
     * - M: month.
     * - Y: years.
     * > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
     */
    @JvmName("kvwluvbtipqwhjmy")
    public suspend fun renewalPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalPeriodUnit = mapped
    }

    /**
     * @param value Automatic renewal status, default ManualRenewal, valid values:
     * - AutoRenewal: automatic renewal.
     * - ManualRenewal: manual renewal.
     */
    @JvmName("cxdlkqkoxvuaxbhb")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("ahardmktqhxhvhsc")
    public suspend fun sasAntiRansomware(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasAntiRansomware = mapped
    }

    /**
     * @param value Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
     * > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
     */
    @JvmName("iqfrflumngdunbxg")
    public suspend fun sasCspm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasCspm = mapped
    }

    /**
     * @param value Cloud platform configuration check switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("tgpbanlvsdpvqwuf")
    public suspend fun sasCspmSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasCspmSwitch = mapped
    }

    /**
     * @param value Security screen. Value:
     * - true: Yes.
     * - false: No.
     */
    @JvmName("tuavirltuwdllukv")
    public suspend fun sasSc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasSc = mapped
    }

    /**
     * @param value Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
     * > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("cwwpirgmbpdkmmpt")
    public suspend fun sasSdk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasSdk = mapped
    }

    /**
     * @param value Malicious file detection SDK.
     */
    @JvmName("nftuwtdgtilofhlf")
    public suspend fun sasSdkSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasSdkSwitch = mapped
    }

    /**
     * @param value Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
     * > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("ybfjtgunotgkwilu")
    public suspend fun sasSlsStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasSlsStorage = mapped
    }

    /**
     * @param value Web tamper-proof switch. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("mfthiesnlveopbak")
    public suspend fun sasWebguardBoolean(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasWebguardBoolean = mapped
    }

    /**
     * @param value Tamper-proof authorization number. Value:
     * - 0: No
     * - 1: Yes.
     */
    @JvmName("mcloqhtlahtrdrar")
    public suspend fun sasWebguardOrderNum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasWebguardOrderNum = mapped
    }

    /**
     * @param value Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
     * > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
     */
    @JvmName("owcatsyuxpcqlfop")
    public suspend fun threatAnalysis(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysis = mapped
    }

    /**
     * @param value Threat analysis. Value:
     * - 0: No.
     * - 1: Yes.
     */
    @JvmName("vwrcnabfgowidsdx")
    public suspend fun threatAnalysisSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatAnalysisSwitch = mapped
    }

    /**
     * @param value Number of cores.
     */
    @JvmName("ypbekfopqkqungys")
    public suspend fun vCore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCore = mapped
    }

    /**
     * @param value Select the security center version. Value:
     * - level7: Antivirus Edition.
     * - level3: Premium version.
     * - level2: Enterprise Edition.
     * - level8: Ultimate.
     * - level10: Purchase value-added services only.
     */
    @JvmName("cvbekedhuhavvwic")
    public suspend fun versionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionCode = mapped
    }

    /**
     * @param value Vulnerability repair times, interval type, value range:[20,100000000].
     * > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
     */
    @JvmName("dasjxtvtlpyvrrcb")
    public suspend fun vulCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulCount = mapped
    }

    /**
     * @param value Vulnerability fix switch. Value:
     * - 0: No.
     * - 1: Yes.
     * > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
     */
    @JvmName("knamfykehamqykus")
    public suspend fun vulSwitch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulSwitch = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        buyNumber = buyNumber,
        containerImageScan = containerImageScan,
        containerImageScanNew = containerImageScanNew,
        honeypot = honeypot,
        honeypotSwitch = honeypotSwitch,
        modifyType = modifyType,
        paymentType = paymentType,
        period = period,
        raspCount = raspCount,
        renewPeriod = renewPeriod,
        renewalPeriodUnit = renewalPeriodUnit,
        renewalStatus = renewalStatus,
        sasAntiRansomware = sasAntiRansomware,
        sasCspm = sasCspm,
        sasCspmSwitch = sasCspmSwitch,
        sasSc = sasSc,
        sasSdk = sasSdk,
        sasSdkSwitch = sasSdkSwitch,
        sasSlsStorage = sasSlsStorage,
        sasWebguardBoolean = sasWebguardBoolean,
        sasWebguardOrderNum = sasWebguardOrderNum,
        threatAnalysis = threatAnalysis,
        threatAnalysisSwitch = threatAnalysisSwitch,
        vCore = vCore,
        versionCode = versionCode,
        vulCount = vulCount,
        vulSwitch = vulSwitch,
    )
}
