@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MaliciousFileWhitelistConfig].
 */
@PulumiTagMarker
public class MaliciousFileWhitelistConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MaliciousFileWhitelistConfigArgs = MaliciousFileWhitelistConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MaliciousFileWhitelistConfigArgsBuilder.() -> Unit) {
        val builder = MaliciousFileWhitelistConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MaliciousFileWhitelistConfig {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MaliciousFileWhitelistConfig(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Malicious File Whitelist Config resource. malicious file add whitelist config.
 * For information about Threat Detection Malicious File Whitelist Config and how to use it, see [What is Malicious File Whitelist Config](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createmaliciousfilewhitelistconfig/).
 * > **NOTE:** Available since v1.214.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.MaliciousFileWhitelistConfig("default", {
 *     operator: "strEquals",
 *     field: "fileMd6",
 *     targetValue: "123",
 *     targetType: "SELECTION_KEY",
 *     eventName: "123",
 *     source: "agentless",
 *     fieldValue: "sadfas",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.MaliciousFileWhitelistConfig("default",
 *     operator="strEquals",
 *     field="fileMd6",
 *     target_value="123",
 *     target_type="SELECTION_KEY",
 *     event_name="123",
 *     source="agentless",
 *     field_value="sadfas")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.MaliciousFileWhitelistConfig("default", new()
 *     {
 *         Operator = "strEquals",
 *         Field = "fileMd6",
 *         TargetValue = "123",
 *         TargetType = "SELECTION_KEY",
 *         EventName = "123",
 *         Source = "agentless",
 *         FieldValue = "sadfas",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewMaliciousFileWhitelistConfig(ctx, "default", &threatdetection.MaliciousFileWhitelistConfigArgs{
 * 			Operator:    pulumi.String("strEquals"),
 * 			Field:       pulumi.String("fileMd6"),
 * 			TargetValue: pulumi.String("123"),
 * 			TargetType:  pulumi.String("SELECTION_KEY"),
 * 			EventName:   pulumi.String("123"),
 * 			Source:      pulumi.String("agentless"),
 * 			FieldValue:  pulumi.String("sadfas"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig;
 * import com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new MaliciousFileWhitelistConfig("default", MaliciousFileWhitelistConfigArgs.builder()
 *             .operator("strEquals")
 *             .field("fileMd6")
 *             .targetValue("123")
 *             .targetType("SELECTION_KEY")
 *             .eventName("123")
 *             .source("agentless")
 *             .fieldValue("sadfas")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:MaliciousFileWhitelistConfig
 *     properties:
 *       operator: strEquals
 *       field: fileMd6
 *       targetValue: '123'
 *       targetType: SELECTION_KEY
 *       eventName: '123'
 *       source: agentless
 *       fieldValue: sadfas
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Malicious File Whitelist Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/maliciousFileWhitelistConfig:MaliciousFileWhitelistConfig example <id>
 * ```
 */
public class MaliciousFileWhitelistConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig,
) : KotlinCustomResource(javaResource, MaliciousFileWhitelistConfigMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The name of the security alert associated with the representative rule.
     */
    public val eventName: Output<String>?
        get() = javaResource.eventName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Represents the alarm associated with the resource and the white field.
     */
    public val `field`: Output<String>?
        get() = javaResource.`field`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Represents the whiteout target value in effect for the resource.
     */
    public val fieldValue: Output<String>?
        get() = javaResource.fieldValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The decision operator in effect on behalf of the resource.
     */
    public val `operator`: Output<String>?
        get() = javaResource.`operator`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Business Source:
     * - agentless: agentless detection.
     */
    public val source: Output<String>?
        get() = javaResource.source().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of target in effect on behalf of the resource.
     */
    public val targetType: Output<String>?
        get() = javaResource.targetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Represents the specific value of the target type in effect for the resource.
     */
    public val targetValue: Output<String>?
        get() = javaResource.targetValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object MaliciousFileWhitelistConfigMapper : ResourceMapper<MaliciousFileWhitelistConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig::class == javaResource::class

    override fun map(javaResource: Resource): MaliciousFileWhitelistConfig =
        MaliciousFileWhitelistConfig(
            javaResource as
                com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig,
        )
}

/**
 * @see [MaliciousFileWhitelistConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MaliciousFileWhitelistConfig].
 */
public suspend fun maliciousFileWhitelistConfig(
    name: String,
    block: suspend MaliciousFileWhitelistConfigResourceBuilder.() -> Unit,
): MaliciousFileWhitelistConfig {
    val builder = MaliciousFileWhitelistConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MaliciousFileWhitelistConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun maliciousFileWhitelistConfig(name: String): MaliciousFileWhitelistConfig {
    val builder = MaliciousFileWhitelistConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
