@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Malicious File Whitelist Config resource. malicious file add whitelist config.
 * For information about Threat Detection Malicious File Whitelist Config and how to use it, see [What is Malicious File Whitelist Config](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createmaliciousfilewhitelistconfig/).
 * > **NOTE:** Available since v1.214.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.MaliciousFileWhitelistConfig("default", {
 *     operator: "strEquals",
 *     field: "fileMd6",
 *     targetValue: "123",
 *     targetType: "SELECTION_KEY",
 *     eventName: "123",
 *     source: "agentless",
 *     fieldValue: "sadfas",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.MaliciousFileWhitelistConfig("default",
 *     operator="strEquals",
 *     field="fileMd6",
 *     target_value="123",
 *     target_type="SELECTION_KEY",
 *     event_name="123",
 *     source="agentless",
 *     field_value="sadfas")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.MaliciousFileWhitelistConfig("default", new()
 *     {
 *         Operator = "strEquals",
 *         Field = "fileMd6",
 *         TargetValue = "123",
 *         TargetType = "SELECTION_KEY",
 *         EventName = "123",
 *         Source = "agentless",
 *         FieldValue = "sadfas",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewMaliciousFileWhitelistConfig(ctx, "default", &threatdetection.MaliciousFileWhitelistConfigArgs{
 * 			Operator:    pulumi.String("strEquals"),
 * 			Field:       pulumi.String("fileMd6"),
 * 			TargetValue: pulumi.String("123"),
 * 			TargetType:  pulumi.String("SELECTION_KEY"),
 * 			EventName:   pulumi.String("123"),
 * 			Source:      pulumi.String("agentless"),
 * 			FieldValue:  pulumi.String("sadfas"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfig;
 * import com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new MaliciousFileWhitelistConfig("default", MaliciousFileWhitelistConfigArgs.builder()
 *             .operator("strEquals")
 *             .field("fileMd6")
 *             .targetValue("123")
 *             .targetType("SELECTION_KEY")
 *             .eventName("123")
 *             .source("agentless")
 *             .fieldValue("sadfas")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:MaliciousFileWhitelistConfig
 *     properties:
 *       operator: strEquals
 *       field: fileMd6
 *       targetValue: '123'
 *       targetType: SELECTION_KEY
 *       eventName: '123'
 *       source: agentless
 *       fieldValue: sadfas
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Malicious File Whitelist Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/maliciousFileWhitelistConfig:MaliciousFileWhitelistConfig example <id>
 * ```
 * @property eventName The name of the security alert associated with the representative rule.
 * @property field Represents the alarm associated with the resource and the white field.
 * @property fieldValue Represents the whiteout target value in effect for the resource.
 * @property operator The decision operator in effect on behalf of the resource.
 * @property source Business Source:
 * - agentless: agentless detection.
 * @property targetType The type of target in effect on behalf of the resource.
 * @property targetValue Represents the specific value of the target type in effect for the resource.
 */
public data class MaliciousFileWhitelistConfigArgs(
    public val eventName: Output<String>? = null,
    public val `field`: Output<String>? = null,
    public val fieldValue: Output<String>? = null,
    public val `operator`: Output<String>? = null,
    public val source: Output<String>? = null,
    public val targetType: Output<String>? = null,
    public val targetValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs =
        com.pulumi.alicloud.threatdetection.MaliciousFileWhitelistConfigArgs.builder()
            .eventName(eventName?.applyValue({ args0 -> args0 }))
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .fieldValue(fieldValue?.applyValue({ args0 -> args0 }))
            .`operator`(`operator`?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 }))
            .targetValue(targetValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaliciousFileWhitelistConfigArgs].
 */
@PulumiTagMarker
public class MaliciousFileWhitelistConfigArgsBuilder internal constructor() {
    private var eventName: Output<String>? = null

    private var `field`: Output<String>? = null

    private var fieldValue: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var source: Output<String>? = null

    private var targetType: Output<String>? = null

    private var targetValue: Output<String>? = null

    /**
     * @param value The name of the security alert associated with the representative rule.
     */
    @JvmName("igrbwofdydflgvld")
    public suspend fun eventName(`value`: Output<String>) {
        this.eventName = value
    }

    /**
     * @param value Represents the alarm associated with the resource and the white field.
     */
    @JvmName("dpogegmpsaiwours")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value Represents the whiteout target value in effect for the resource.
     */
    @JvmName("xoejeocifpaekvtv")
    public suspend fun fieldValue(`value`: Output<String>) {
        this.fieldValue = value
    }

    /**
     * @param value The decision operator in effect on behalf of the resource.
     */
    @JvmName("dfpnaecelotbqjut")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value Business Source:
     * - agentless: agentless detection.
     */
    @JvmName("pmynvpbihxwwsfip")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The type of target in effect on behalf of the resource.
     */
    @JvmName("swdodnlbtwdbkarh")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value Represents the specific value of the target type in effect for the resource.
     */
    @JvmName("xygeuuqiesurvcxk")
    public suspend fun targetValue(`value`: Output<String>) {
        this.targetValue = value
    }

    /**
     * @param value The name of the security alert associated with the representative rule.
     */
    @JvmName("trjoyutduehepjgo")
    public suspend fun eventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventName = mapped
    }

    /**
     * @param value Represents the alarm associated with the resource and the white field.
     */
    @JvmName("yyplfbxdayovprcr")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value Represents the whiteout target value in effect for the resource.
     */
    @JvmName("svcmykuyljjrivkx")
    public suspend fun fieldValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldValue = mapped
    }

    /**
     * @param value The decision operator in effect on behalf of the resource.
     */
    @JvmName("oefgmmhbnchycsqj")
    public suspend fun `operator`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Business Source:
     * - agentless: agentless detection.
     */
    @JvmName("hyhwbcolrmpclejs")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The type of target in effect on behalf of the resource.
     */
    @JvmName("atqsgedokdajkkra")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Represents the specific value of the target type in effect for the resource.
     */
    @JvmName("kljsijwtjgqocoel")
    public suspend fun targetValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetValue = mapped
    }

    internal fun build(): MaliciousFileWhitelistConfigArgs = MaliciousFileWhitelistConfigArgs(
        eventName = eventName,
        `field` = `field`,
        fieldValue = fieldValue,
        `operator` = `operator`,
        source = source,
        targetType = targetType,
        targetValue = targetValue,
    )
}
