@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.OssScanConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Oss Scan Config resource. Oss detection configuration.
 * For information about Threat Detection Oss Scan Config and how to use it, see [What is Oss Scan Config](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createossscanconfig/).
 * > **NOTE:** Available since v1.214.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const bucketRandom = _default.result;
 * const default8j4t1R = new alicloud.oss.Bucket("default8j4t1R", {
 *     bucket: `${name}-1-${bucketRandom}`,
 *     storageClass: "Standard",
 * });
 * const default9HMqfT = new alicloud.oss.Bucket("default9HMqfT", {
 *     bucket: `${name}-2-${bucketRandom}`,
 *     storageClass: "Standard",
 * });
 * const defaultxBXqFQ = new alicloud.oss.Bucket("defaultxBXqFQ", {
 *     bucket: `${name}-3-${bucketRandom}`,
 *     storageClass: "Standard",
 * });
 * const defaulthZvCmR = new alicloud.oss.Bucket("defaulthZvCmR", {
 *     bucket: `${name}-4-${bucketRandom}`,
 *     storageClass: "Standard",
 * });
 * const defaultOssScanConfig = new alicloud.threatdetection.OssScanConfig("default", {
 *     keySuffixLists: [
 *         ".jsp",
 *         ".php",
 *         ".k",
 *     ],
 *     scanDayLists: [
 *         2,
 *         5,
 *         4,
 *         3,
 *     ],
 *     ossScanConfigName: name,
 *     endTime: "00:00:02",
 *     startTime: "00:00:01",
 *     enable: 1,
 *     allKeyPrefix: false,
 *     bucketNameLists: [
 *         default8j4t1R.bucket,
 *         default9HMqfT.bucket,
 *         defaultxBXqFQ.bucket,
 *     ],
 *     keyPrefixLists: [
 *         "/root",
 *         "/usr",
 *         "/123",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * bucket_random = default["result"]
 * default8j4t1_r = alicloud.oss.Bucket("default8j4t1R",
 *     bucket=f"{name}-1-{bucket_random}",
 *     storage_class="Standard")
 * default9_h_mqf_t = alicloud.oss.Bucket("default9HMqfT",
 *     bucket=f"{name}-2-{bucket_random}",
 *     storage_class="Standard")
 * defaultx_b_xq_fq = alicloud.oss.Bucket("defaultxBXqFQ",
 *     bucket=f"{name}-3-{bucket_random}",
 *     storage_class="Standard")
 * defaulth_zv_cm_r = alicloud.oss.Bucket("defaulthZvCmR",
 *     bucket=f"{name}-4-{bucket_random}",
 *     storage_class="Standard")
 * default_oss_scan_config = alicloud.threatdetection.OssScanConfig("default",
 *     key_suffix_lists=[
 *         ".jsp",
 *         ".php",
 *         ".k",
 *     ],
 *     scan_day_lists=[
 *         2,
 *         5,
 *         4,
 *         3,
 *     ],
 *     oss_scan_config_name=name,
 *     end_time="00:00:02",
 *     start_time="00:00:01",
 *     enable=1,
 *     all_key_prefix=False,
 *     bucket_name_lists=[
 *         default8j4t1_r.bucket,
 *         default9_h_mqf_t.bucket,
 *         defaultx_b_xq_fq.bucket,
 *     ],
 *     key_prefix_lists=[
 *         "/root",
 *         "/usr",
 *         "/123",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var bucketRandom = @default.Result;
 *     var default8j4t1R = new AliCloud.Oss.Bucket("default8j4t1R", new()
 *     {
 *         BucketName = $"{name}-1-{bucketRandom}",
 *         StorageClass = "Standard",
 *     });
 *     var default9HMqfT = new AliCloud.Oss.Bucket("default9HMqfT", new()
 *     {
 *         BucketName = $"{name}-2-{bucketRandom}",
 *         StorageClass = "Standard",
 *     });
 *     var defaultxBXqFQ = new AliCloud.Oss.Bucket("defaultxBXqFQ", new()
 *     {
 *         BucketName = $"{name}-3-{bucketRandom}",
 *         StorageClass = "Standard",
 *     });
 *     var defaulthZvCmR = new AliCloud.Oss.Bucket("defaulthZvCmR", new()
 *     {
 *         BucketName = $"{name}-4-{bucketRandom}",
 *         StorageClass = "Standard",
 *     });
 *     var defaultOssScanConfig = new AliCloud.ThreatDetection.OssScanConfig("default", new()
 *     {
 *         KeySuffixLists = new[]
 *         {
 *             ".jsp",
 *             ".php",
 *             ".k",
 *         },
 *         ScanDayLists = new[]
 *         {
 *             2,
 *             5,
 *             4,
 *             3,
 *         },
 *         OssScanConfigName = name,
 *         EndTime = "00:00:02",
 *         StartTime = "00:00:01",
 *         Enable = 1,
 *         AllKeyPrefix = false,
 *         BucketNameLists = new[]
 *         {
 *             default8j4t1R.BucketName,
 *             default9HMqfT.BucketName,
 *             defaultxBXqFQ.BucketName,
 *         },
 *         KeyPrefixLists = new[]
 *         {
 *             "/root",
 *             "/usr",
 *             "/123",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/oss"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bucketRandom := _default.Result
 * 		default8j4t1R, err := oss.NewBucket(ctx, "default8j4t1R", &oss.BucketArgs{
 * 			Bucket:       pulumi.Sprintf("%v-1-%v", name, bucketRandom),
 * 			StorageClass: pulumi.String("Standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default9HMqfT, err := oss.NewBucket(ctx, "default9HMqfT", &oss.BucketArgs{
 * 			Bucket:       pulumi.Sprintf("%v-2-%v", name, bucketRandom),
 * 			StorageClass: pulumi.String("Standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultxBXqFQ, err := oss.NewBucket(ctx, "defaultxBXqFQ", &oss.BucketArgs{
 * 			Bucket:       pulumi.Sprintf("%v-3-%v", name, bucketRandom),
 * 			StorageClass: pulumi.String("Standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = oss.NewBucket(ctx, "defaulthZvCmR", &oss.BucketArgs{
 * 			Bucket:       pulumi.Sprintf("%v-4-%v", name, bucketRandom),
 * 			StorageClass: pulumi.String("Standard"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewOssScanConfig(ctx, "default", &threatdetection.OssScanConfigArgs{
 * 			KeySuffixLists: pulumi.StringArray{
 * 				pulumi.String(".jsp"),
 * 				pulumi.String(".php"),
 * 				pulumi.String(".k"),
 * 			},
 * 			ScanDayLists: pulumi.IntArray{
 * 				pulumi.Int(2),
 * 				pulumi.Int(5),
 * 				pulumi.Int(4),
 * 				pulumi.Int(3),
 * 			},
 * 			OssScanConfigName: pulumi.String(name),
 * 			EndTime:           pulumi.String("00:00:02"),
 * 			StartTime:         pulumi.String("00:00:01"),
 * 			Enable:            pulumi.Int(1),
 * 			AllKeyPrefix:      pulumi.Bool(false),
 * 			BucketNameLists: pulumi.StringArray{
 * 				default8j4t1R.Bucket,
 * 				default9HMqfT.Bucket,
 * 				defaultxBXqFQ.Bucket,
 * 			},
 * 			KeyPrefixLists: pulumi.StringArray{
 * 				pulumi.String("/root"),
 * 				pulumi.String("/usr"),
 * 				pulumi.String("/123"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.oss.Bucket;
 * import com.pulumi.alicloud.oss.BucketArgs;
 * import com.pulumi.alicloud.threatdetection.OssScanConfig;
 * import com.pulumi.alicloud.threatdetection.OssScanConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var bucketRandom = default_.result();
 *         var default8j4t1R = new Bucket("default8j4t1R", BucketArgs.builder()
 *             .bucket(String.format("%s-1-%s", name,bucketRandom))
 *             .storageClass("Standard")
 *             .build());
 *         var default9HMqfT = new Bucket("default9HMqfT", BucketArgs.builder()
 *             .bucket(String.format("%s-2-%s", name,bucketRandom))
 *             .storageClass("Standard")
 *             .build());
 *         var defaultxBXqFQ = new Bucket("defaultxBXqFQ", BucketArgs.builder()
 *             .bucket(String.format("%s-3-%s", name,bucketRandom))
 *             .storageClass("Standard")
 *             .build());
 *         var defaulthZvCmR = new Bucket("defaulthZvCmR", BucketArgs.builder()
 *             .bucket(String.format("%s-4-%s", name,bucketRandom))
 *             .storageClass("Standard")
 *             .build());
 *         var defaultOssScanConfig = new OssScanConfig("defaultOssScanConfig", OssScanConfigArgs.builder()
 *             .keySuffixLists(
 *                 ".jsp",
 *                 ".php",
 *                 ".k")
 *             .scanDayLists(
 *                 "2",
 *                 "5",
 *                 "4",
 *                 "3")
 *             .ossScanConfigName(name)
 *             .endTime("00:00:02")
 *             .startTime("00:00:01")
 *             .enable("1")
 *             .allKeyPrefix("false")
 *             .bucketNameLists(
 *                 default8j4t1R.bucket(),
 *                 default9HMqfT.bucket(),
 *                 defaultxBXqFQ.bucket())
 *             .keyPrefixLists(
 *                 "/root",
 *                 "/usr",
 *                 "/123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   default8j4t1R:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: ${name}-1-${bucketRandom}
 *       storageClass: Standard
 *   default9HMqfT:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: ${name}-2-${bucketRandom}
 *       storageClass: Standard
 *   defaultxBXqFQ:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: ${name}-3-${bucketRandom}
 *       storageClass: Standard
 *   defaulthZvCmR:
 *     type: alicloud:oss:Bucket
 *     properties:
 *       bucket: ${name}-4-${bucketRandom}
 *       storageClass: Standard
 *   defaultOssScanConfig:
 *     type: alicloud:threatdetection:OssScanConfig
 *     name: default
 *     properties:
 *       keySuffixLists:
 *         - .jsp
 *         - .php
 *         - .k
 *       scanDayLists:
 *         - '2'
 *         - '5'
 *         - '4'
 *         - '3'
 *       ossScanConfigName: ${name}
 *       endTime: 00:00:02
 *       startTime: 00:00:01
 *       enable: '1'
 *       allKeyPrefix: 'false'
 *       bucketNameLists:
 *         - ${default8j4t1R.bucket}
 *         - ${default9HMqfT.bucket}
 *         - ${defaultxBXqFQ.bucket}
 *       keyPrefixLists:
 *         - /root
 *         - /usr
 *         - /123
 * variables:
 *   bucketRandom: ${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Oss Scan Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/ossScanConfig:OssScanConfig example <id>
 * ```
 * @property allKeyPrefix Match all prefixes.
 * @property bucketNameLists Bucket List.
 * @property enable Enable configuration.
 * @property endTime End time, hours, minutes and seconds.
 * @property keyPrefixLists File prefix list.
 * @property keySuffixLists File Suffix List.
 * @property ossScanConfigName Configuration Name.
 * @property scanDayLists Scan cycle.
 * @property startTime Start time, hours, minutes and seconds.
 */
public data class OssScanConfigArgs(
    public val allKeyPrefix: Output<Boolean>? = null,
    public val bucketNameLists: Output<List<String>>? = null,
    public val enable: Output<Int>? = null,
    public val endTime: Output<String>? = null,
    public val keyPrefixLists: Output<List<String>>? = null,
    public val keySuffixLists: Output<List<String>>? = null,
    public val ossScanConfigName: Output<String>? = null,
    public val scanDayLists: Output<List<Int>>? = null,
    public val startTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.OssScanConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.OssScanConfigArgs =
        com.pulumi.alicloud.threatdetection.OssScanConfigArgs.builder()
            .allKeyPrefix(allKeyPrefix?.applyValue({ args0 -> args0 }))
            .bucketNameLists(bucketNameLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .keyPrefixLists(keyPrefixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keySuffixLists(keySuffixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ossScanConfigName(ossScanConfigName?.applyValue({ args0 -> args0 }))
            .scanDayLists(scanDayLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .startTime(startTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OssScanConfigArgs].
 */
@PulumiTagMarker
public class OssScanConfigArgsBuilder internal constructor() {
    private var allKeyPrefix: Output<Boolean>? = null

    private var bucketNameLists: Output<List<String>>? = null

    private var enable: Output<Int>? = null

    private var endTime: Output<String>? = null

    private var keyPrefixLists: Output<List<String>>? = null

    private var keySuffixLists: Output<List<String>>? = null

    private var ossScanConfigName: Output<String>? = null

    private var scanDayLists: Output<List<Int>>? = null

    private var startTime: Output<String>? = null

    /**
     * @param value Match all prefixes.
     */
    @JvmName("nbjieweohiblkgeq")
    public suspend fun allKeyPrefix(`value`: Output<Boolean>) {
        this.allKeyPrefix = value
    }

    /**
     * @param value Bucket List.
     */
    @JvmName("rlhrtjkokpjeyypk")
    public suspend fun bucketNameLists(`value`: Output<List<String>>) {
        this.bucketNameLists = value
    }

    @JvmName("gwdmkldcfhmtbhda")
    public suspend fun bucketNameLists(vararg values: Output<String>) {
        this.bucketNameLists = Output.all(values.asList())
    }

    /**
     * @param values Bucket List.
     */
    @JvmName("awtxoneixnfmyqff")
    public suspend fun bucketNameLists(values: List<Output<String>>) {
        this.bucketNameLists = Output.all(values)
    }

    /**
     * @param value Enable configuration.
     */
    @JvmName("eanilureskmdswhq")
    public suspend fun enable(`value`: Output<Int>) {
        this.enable = value
    }

    /**
     * @param value End time, hours, minutes and seconds.
     */
    @JvmName("cbmmcbmvudexiknj")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value File prefix list.
     */
    @JvmName("ovxknlnhrwxrmugc")
    public suspend fun keyPrefixLists(`value`: Output<List<String>>) {
        this.keyPrefixLists = value
    }

    @JvmName("jytthqfsvepaxwuh")
    public suspend fun keyPrefixLists(vararg values: Output<String>) {
        this.keyPrefixLists = Output.all(values.asList())
    }

    /**
     * @param values File prefix list.
     */
    @JvmName("osjhyessbsbholsi")
    public suspend fun keyPrefixLists(values: List<Output<String>>) {
        this.keyPrefixLists = Output.all(values)
    }

    /**
     * @param value File Suffix List.
     */
    @JvmName("pgqbolxrbqkuelwf")
    public suspend fun keySuffixLists(`value`: Output<List<String>>) {
        this.keySuffixLists = value
    }

    @JvmName("rskygubisuesuoxx")
    public suspend fun keySuffixLists(vararg values: Output<String>) {
        this.keySuffixLists = Output.all(values.asList())
    }

    /**
     * @param values File Suffix List.
     */
    @JvmName("sejrpucxeohswxmf")
    public suspend fun keySuffixLists(values: List<Output<String>>) {
        this.keySuffixLists = Output.all(values)
    }

    /**
     * @param value Configuration Name.
     */
    @JvmName("eumnqomhdquwfmtn")
    public suspend fun ossScanConfigName(`value`: Output<String>) {
        this.ossScanConfigName = value
    }

    /**
     * @param value Scan cycle.
     */
    @JvmName("vstgovcrnouwjvhr")
    public suspend fun scanDayLists(`value`: Output<List<Int>>) {
        this.scanDayLists = value
    }

    @JvmName("rjbieoghlgmubkvt")
    public suspend fun scanDayLists(vararg values: Output<Int>) {
        this.scanDayLists = Output.all(values.asList())
    }

    /**
     * @param values Scan cycle.
     */
    @JvmName("ylvauttkgnxxbyud")
    public suspend fun scanDayLists(values: List<Output<Int>>) {
        this.scanDayLists = Output.all(values)
    }

    /**
     * @param value Start time, hours, minutes and seconds.
     */
    @JvmName("hrsvestnypoaoxuu")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Match all prefixes.
     */
    @JvmName("fevpyrvtdsvboxwh")
    public suspend fun allKeyPrefix(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allKeyPrefix = mapped
    }

    /**
     * @param value Bucket List.
     */
    @JvmName("jumijcnntrwhjjnu")
    public suspend fun bucketNameLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketNameLists = mapped
    }

    /**
     * @param values Bucket List.
     */
    @JvmName("tjxffvgsiqxeknhb")
    public suspend fun bucketNameLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketNameLists = mapped
    }

    /**
     * @param value Enable configuration.
     */
    @JvmName("ovgvpuarxnamsfew")
    public suspend fun enable(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value End time, hours, minutes and seconds.
     */
    @JvmName("giqxfrwthvsbyplt")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value File prefix list.
     */
    @JvmName("ttqalkedhmynjncq")
    public suspend fun keyPrefixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPrefixLists = mapped
    }

    /**
     * @param values File prefix list.
     */
    @JvmName("oljqcbnnyturgbcg")
    public suspend fun keyPrefixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyPrefixLists = mapped
    }

    /**
     * @param value File Suffix List.
     */
    @JvmName("qumpmynumswqracd")
    public suspend fun keySuffixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySuffixLists = mapped
    }

    /**
     * @param values File Suffix List.
     */
    @JvmName("bqesxwtkhsswsjmi")
    public suspend fun keySuffixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySuffixLists = mapped
    }

    /**
     * @param value Configuration Name.
     */
    @JvmName("hhltxqswvlhkhmrs")
    public suspend fun ossScanConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossScanConfigName = mapped
    }

    /**
     * @param value Scan cycle.
     */
    @JvmName("vvjsqtlnufcnncpd")
    public suspend fun scanDayLists(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanDayLists = mapped
    }

    /**
     * @param values Scan cycle.
     */
    @JvmName("rpinfgubuireptjk")
    public suspend fun scanDayLists(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scanDayLists = mapped
    }

    /**
     * @param value Start time, hours, minutes and seconds.
     */
    @JvmName("sscqixyekugxrfpd")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    internal fun build(): OssScanConfigArgs = OssScanConfigArgs(
        allKeyPrefix = allKeyPrefix,
        bucketNameLists = bucketNameLists,
        enable = enable,
        endTime = endTime,
        keyPrefixLists = keyPrefixLists,
        keySuffixLists = keySuffixLists,
        ossScanConfigName = ossScanConfigName,
        scanDayLists = scanDayLists,
        startTime = startTime,
    )
}
