@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.kotlin.outputs.SasTrailServiceTrail
import com.pulumi.alicloud.threatdetection.kotlin.outputs.SasTrailServiceTrail.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SasTrail].
 */
@PulumiTagMarker
public class SasTrailResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SasTrailArgs = SasTrailArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SasTrailArgsBuilder.() -> Unit) {
        val builder = SasTrailArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SasTrail {
        val builtJavaResource = com.pulumi.alicloud.threatdetection.SasTrail(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SasTrail(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Sas Trail resource.
 * For information about Threat Detection Sas Trail and how to use it, see [What is Sas Trail](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createservicetrail).
 * > **NOTE:** Available since v1.212.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.threatdetection.SasTrail("default", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.threatdetection.SasTrail("default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.ThreatDetection.SasTrail("default");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := threatdetection.NewSasTrail(ctx, "default", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.SasTrail;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new SasTrail("default");
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:threatdetection:SasTrail
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Sas Trail can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/sasTrail:SasTrail example
 * ```
 */
public class SasTrail internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.SasTrail,
) : KotlinCustomResource(javaResource, SasTrailMapper) {
    /**
     * The service trace creation timestamp, in milliseconds.
     */
    public val createTime: Output<Int>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Service trace configuration information.
     */
    public val serviceTrail: Output<SasTrailServiceTrail>
        get() = javaResource.serviceTrail().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object SasTrailMapper : ResourceMapper<SasTrail> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.SasTrail::class == javaResource::class

    override fun map(javaResource: Resource): SasTrail = SasTrail(
        javaResource as
            com.pulumi.alicloud.threatdetection.SasTrail,
    )
}

/**
 * @see [SasTrail].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SasTrail].
 */
public suspend fun sasTrail(name: String, block: suspend SasTrailResourceBuilder.() -> Unit): SasTrail {
    val builder = SasTrailResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SasTrail].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sasTrail(name: String): SasTrail {
    val builder = SasTrailResourceBuilder()
    builder.name(name)
    return builder.build()
}
