@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getAntiBruteForceRulesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getAssetsPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getBackupPoliciesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getBaselineStrategiesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getHoneyPotsPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getHoneypotImagesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getHoneypotNodesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getHoneypotPresetsPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getHoneypotProbesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getInstancesPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getLogShipperPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getVulWhitelistsPlain
import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions.getWebLockConfigsPlain
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetAntiBruteForceRulesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetAntiBruteForceRulesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetAssetsPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetAssetsPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetBackupPoliciesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetBackupPoliciesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetBaselineStrategiesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetBaselineStrategiesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneyPotsPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneyPotsPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotImagesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotImagesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotNodesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotNodesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotPresetsPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotPresetsPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotProbesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetHoneypotProbesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetLogShipperPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetLogShipperPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetVulWhitelistsPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetVulWhitelistsPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetWebLockConfigsPlainArgs
import com.pulumi.alicloud.threatdetection.kotlin.inputs.GetWebLockConfigsPlainArgsBuilder
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAntiBruteForceRulesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAssetsResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBackupPoliciesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBaselineStrategiesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneyPotsResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotImagesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotNodesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotPresetsResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotProbesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetLogShipperResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetVulWhitelistsResult
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetWebLockConfigsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAntiBruteForceRulesResult.Companion.toKotlin as getAntiBruteForceRulesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAssetsResult.Companion.toKotlin as getAssetsResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBackupPoliciesResult.Companion.toKotlin as getBackupPoliciesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBaselineStrategiesResult.Companion.toKotlin as getBaselineStrategiesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneyPotsResult.Companion.toKotlin as getHoneyPotsResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotImagesResult.Companion.toKotlin as getHoneypotImagesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotNodesResult.Companion.toKotlin as getHoneypotNodesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotPresetsResult.Companion.toKotlin as getHoneypotPresetsResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotProbesResult.Companion.toKotlin as getHoneypotProbesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetLogShipperResult.Companion.toKotlin as getLogShipperResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetVulWhitelistsResult.Companion.toKotlin as getVulWhitelistsResultToKotlin
import com.pulumi.alicloud.threatdetection.kotlin.outputs.GetWebLockConfigsResult.Companion.toKotlin as getWebLockConfigsResultToKotlin

public object ThreatdetectionFunctions {
    /**
     * This data source provides Threat Detection Anti Brute Force Rule available to the user.[What is Anti Brute Force Rule](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-createantibruteforcerule)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "example_value";
     * const defaultAntiBruteForceRule = new alicloud.threatdetection.AntiBruteForceRule("default", {
     *     antiBruteForceRuleName: name,
     *     forbiddenTime: 360,
     *     uuidLists: ["7567806c-4ec5-4597-9543-7c9543381a13"],
     *     failCount: 80,
     *     span: 10,
     * });
     * const default = defaultAntiBruteForceRule.id.apply(id => alicloud.threatdetection.getAntiBruteForceRulesOutput({
     *     ids: [id],
     *     nameRegex: defaultAntiBruteForceRule.name,
     * }));
     * export const alicloudThreatDetectionAntiBruteForceRuleExampleId = _default.apply(_default => _default.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "example_value"
     * default_anti_brute_force_rule = alicloud.threatdetection.AntiBruteForceRule("default",
     *     anti_brute_force_rule_name=name,
     *     forbidden_time=360,
     *     uuid_lists=["7567806c-4ec5-4597-9543-7c9543381a13"],
     *     fail_count=80,
     *     span=10)
     * default = default_anti_brute_force_rule.id.apply(lambda id: alicloud.threatdetection.get_anti_brute_force_rules_output(ids=[id],
     *     name_regex=default_anti_brute_force_rule.name))
     * pulumi.export("alicloudThreatDetectionAntiBruteForceRuleExampleId", default.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "example_value";
     *     var defaultAntiBruteForceRule = new AliCloud.ThreatDetection.AntiBruteForceRule("default", new()
     *     {
     *         AntiBruteForceRuleName = name,
     *         ForbiddenTime = 360,
     *         UuidLists = new[]
     *         {
     *             "7567806c-4ec5-4597-9543-7c9543381a13",
     *         },
     *         FailCount = 80,
     *         Span = 10,
     *     });
     *     var @default = AliCloud.ThreatDetection.GetAntiBruteForceRules.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAntiBruteForceRule.Id,
     *         },
     *         NameRegex = defaultAntiBruteForceRule.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionAntiBruteForceRuleExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getAntiBruteForceRulesResult => getAntiBruteForceRulesResult&#46;Rules[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "example_value";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * defaultAntiBruteForceRule, err := threatdetection.NewAntiBruteForceRule(ctx, "default", &threatdetection.AntiBruteForceRuleArgs{
     * AntiBruteForceRuleName: pulumi.String(name),
     * ForbiddenTime: pulumi.Int(360),
     * UuidLists: pulumi.StringArray{
     * pulumi.String("7567806c-4ec5-4597-9543-7c9543381a13"),
     * },
     * FailCount: pulumi.Int(80),
     * Span: pulumi.Int(10),
     * })
     * if err != nil {
     * return err
     * }
     * _default := defaultAntiBruteForceRule.ID().ApplyT(func(id string) (threatdetection.GetAntiBruteForceRulesResult, error) {
     * return threatdetection.GetAntiBruteForceRulesResult(interface{}(threatdetection.GetAntiBruteForceRulesOutput(ctx, threatdetection.GetAntiBruteForceRulesOutputArgs{
     * Ids: []string{
     * id,
     * },
     * NameRegex: defaultAntiBruteForceRule.Name,
     * }, nil))), nil
     * }).(threatdetection.GetAntiBruteForceRulesResultOutput)
     * ctx.Export("alicloudThreatDetectionAntiBruteForceRuleExampleId", _default.ApplyT(func(_default threatdetection.GetAntiBruteForceRulesResult) (*string, error) {
     * return &default.Rules[0].Id, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.AntiBruteForceRule;
     * import com.pulumi.alicloud.threatdetection.AntiBruteForceRuleArgs;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetAntiBruteForceRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("example_value");
     *         var defaultAntiBruteForceRule = new AntiBruteForceRule("defaultAntiBruteForceRule", AntiBruteForceRuleArgs.builder()
     *             .antiBruteForceRuleName(name)
     *             .forbiddenTime(360)
     *             .uuidLists("7567806c-4ec5-4597-9543-7c9543381a13")
     *             .failCount(80)
     *             .span(10)
     *             .build());
     *         final var default = ThreatdetectionFunctions.getAntiBruteForceRules(GetAntiBruteForceRulesArgs.builder()
     *             .ids(defaultAntiBruteForceRule.id())
     *             .nameRegex(defaultAntiBruteForceRule.name())
     *             .build());
     *         ctx.export("alicloudThreatDetectionAntiBruteForceRuleExampleId", default_.applyValue(default_ -> default_.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: example_value
     * resources:
     *   defaultAntiBruteForceRule:
     *     type: alicloud:threatdetection:AntiBruteForceRule
     *     name: default
     *     properties:
     *       antiBruteForceRuleName: ${name}
     *       forbiddenTime: 360
     *       uuidLists:
     *         - 7567806c-4ec5-4597-9543-7c9543381a13
     *       failCount: 80
     *       span: 10
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getAntiBruteForceRules
     *       Arguments:
     *         ids:
     *           - ${defaultAntiBruteForceRule.id}
     *         nameRegex: ${defaultAntiBruteForceRule.name}
     * outputs:
     *   alicloudThreatDetectionAntiBruteForceRuleExampleId: ${default.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAntiBruteForceRules.
     * @return A collection of values returned by getAntiBruteForceRules.
     */
    public suspend fun getAntiBruteForceRules(argument: GetAntiBruteForceRulesPlainArgs): GetAntiBruteForceRulesResult =
        getAntiBruteForceRulesResultToKotlin(getAntiBruteForceRulesPlain(argument.toJava()).await())

    /**
     * @see [getAntiBruteForceRules].
     * @param ids A list of Anti-Brute Force Rule IDs.
     * @param nameRegex A regex string to filter results by the name of the defense rule.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAntiBruteForceRules.
     */
    public suspend fun getAntiBruteForceRules(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAntiBruteForceRulesResult {
        val argument = GetAntiBruteForceRulesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAntiBruteForceRulesResultToKotlin(getAntiBruteForceRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAntiBruteForceRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetAntiBruteForceRulesPlainArgs].
     * @return A collection of values returned by getAntiBruteForceRules.
     */
    public suspend fun getAntiBruteForceRules(argument: suspend GetAntiBruteForceRulesPlainArgsBuilder.() -> Unit): GetAntiBruteForceRulesResult {
        val builder = GetAntiBruteForceRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAntiBruteForceRulesResultToKotlin(getAntiBruteForceRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Asset available to the user.[What is Asset](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describecloudcenterinstances)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getAssets({});
     * export const alicloudThreatDetectionAssetExampleId = _default.then(_default => _default.assets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_assets()
     * pulumi.export("alicloudThreatDetectionAssetExampleId", default.assets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetAssets.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionAssetExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getAssetsResult => getAssetsResult&#46;Assets[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := threatdetection.GetAssets(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudThreatDetectionAssetExampleId", _default.Assets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetAssetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getAssets();
     *         ctx.export("alicloudThreatDetectionAssetExampleId", default_.assets()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getAssets
     *       Arguments: {}
     * outputs:
     *   alicloudThreatDetectionAssetExampleId: ${default.assets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAssets.
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(argument: GetAssetsPlainArgs): GetAssetsResult =
        getAssetsResultToKotlin(getAssetsPlain(argument.toJava()).await())

    /**
     * @see [getAssets].
     * @param criteria Set the conditions for searching assets. This parameter is in JSON format. Note the case when you enter the parameter. **NOTE:** You can search for assets by using conditions such as the instance ID, instance name, VPC ID, region, and public IP address of the asset.
     * @param ids A list of Asset IDs.
     * @param importance Set asset importance. Value:
     * - **2**: Significant assets
     * - **1**: General assets
     * - **0**: Test asset
     * @param logicalExp Set the logical relationship between multiple search conditions. The default value is **OR**. Valid values:
     * - **OR**: indicates that the relationship between multiple search conditions is **OR**.
     * - **AND**: indicates that the relationship between multiple search conditions is **AND**.
     * @param machineTypes The type of asset to query. Value:
     * - **ecs**: server.
     * - **cloud_product**: Cloud product.
     * @param noGroupTrace Specifies whether to internationalize the name of the default group. Default value: false
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(
        criteria: String? = null,
        ids: List<String>? = null,
        importance: Int? = null,
        logicalExp: String? = null,
        machineTypes: String? = null,
        noGroupTrace: Boolean? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetAssetsResult {
        val argument = GetAssetsPlainArgs(
            criteria = criteria,
            ids = ids,
            importance = importance,
            logicalExp = logicalExp,
            machineTypes = machineTypes,
            noGroupTrace = noGroupTrace,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getAssetsResultToKotlin(getAssetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetAssetsPlainArgs].
     * @return A collection of values returned by getAssets.
     */
    public suspend fun getAssets(argument: suspend GetAssetsPlainArgsBuilder.() -> Unit): GetAssetsResult {
        val builder = GetAssetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetsResultToKotlin(getAssetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Threat Detection Backup Policies of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.threatdetection.getBackupPolicies({
     *     ids: ["example_id"],
     * });
     * export const threatDetectionBackupPoliciesId1 = ids.then(ids => ids.policies?.[0]?.id);
     * const nameRegex = alicloud.threatdetection.getBackupPolicies({
     *     nameRegex: "tf-example",
     * });
     * export const threatDetectionBackupPoliciesId2 = nameRegex.then(nameRegex => nameRegex.policies?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.threatdetection.get_backup_policies(ids=["example_id"])
     * pulumi.export("threatDetectionBackupPoliciesId1", ids.policies[0].id)
     * name_regex = alicloud.threatdetection.get_backup_policies(name_regex="tf-example")
     * pulumi.export("threatDetectionBackupPoliciesId2", name_regex.policies[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.ThreatDetection.GetBackupPolicies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var nameRegex = AliCloud.ThreatDetection.GetBackupPolicies.Invoke(new()
     *     {
     *         NameRegex = "tf-example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["threatDetectionBackupPoliciesId1"] = ids&#46;Apply(getBackupPoliciesResult => getBackupPoliciesResult&#46;Policies[0]?.Id),
     *         ["threatDetectionBackupPoliciesId2"] = nameRegex&#46;Apply(getBackupPoliciesResult => getBackupPoliciesResult&#46;Policies[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := threatdetection.GetBackupPolicies(ctx, &threatdetection.GetBackupPoliciesArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("threatDetectionBackupPoliciesId1", ids.Policies[0].Id)
     * 		nameRegex, err := threatdetection.GetBackupPolicies(ctx, &threatdetection.GetBackupPoliciesArgs{
     * 			NameRegex: pulumi.StringRef("tf-example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("threatDetectionBackupPoliciesId2", nameRegex.Policies[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetBackupPoliciesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ThreatdetectionFunctions.getBackupPolicies(GetBackupPoliciesArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("threatDetectionBackupPoliciesId1", ids.applyValue(getBackupPoliciesResult -> getBackupPoliciesResult.policies()[0].id()));
     *         final var nameRegex = ThreatdetectionFunctions.getBackupPolicies(GetBackupPoliciesArgs.builder()
     *             .nameRegex("tf-example")
     *             .build());
     *         ctx.export("threatDetectionBackupPoliciesId2", nameRegex.applyValue(getBackupPoliciesResult -> getBackupPoliciesResult.policies()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getBackupPolicies
     *       Arguments:
     *         ids:
     *           - example_id
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getBackupPolicies
     *       Arguments:
     *         nameRegex: tf-example
     * outputs:
     *   threatDetectionBackupPoliciesId1: ${ids.policies[0].id}
     *   threatDetectionBackupPoliciesId2: ${nameRegex.policies[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackupPolicies.
     * @return A collection of values returned by getBackupPolicies.
     */
    public suspend fun getBackupPolicies(argument: GetBackupPoliciesPlainArgs): GetBackupPoliciesResult =
        getBackupPoliciesResultToKotlin(getBackupPoliciesPlain(argument.toJava()).await())

    /**
     * @see [getBackupPolicies].
     * @param currentPage
     * @param ids A list of Threat Detection Backup Policies IDs.
     * @param machineRemark The information that you want to use to identify the servers protected by the anti-ransomware policy. You can enter the IP address or ID of a server.
     * @param name The name of the anti-ransomware policy that you want to query.
     * @param nameRegex A regex string to filter results by Threat Detection Backup Policies name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageSize
     * @param status The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
     * @return A collection of values returned by getBackupPolicies.
     */
    public suspend fun getBackupPolicies(
        currentPage: Int? = null,
        ids: List<String>? = null,
        machineRemark: String? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageSize: Int? = null,
        status: String? = null,
    ): GetBackupPoliciesResult {
        val argument = GetBackupPoliciesPlainArgs(
            currentPage = currentPage,
            ids = ids,
            machineRemark = machineRemark,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageSize = pageSize,
            status = status,
        )
        return getBackupPoliciesResultToKotlin(getBackupPoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPolicies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetBackupPoliciesPlainArgs].
     * @return A collection of values returned by getBackupPolicies.
     */
    public suspend fun getBackupPolicies(argument: suspend GetBackupPoliciesPlainArgsBuilder.() -> Unit): GetBackupPoliciesResult {
        val builder = GetBackupPoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupPoliciesResultToKotlin(getBackupPoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Baseline Strategy available to the user.[What is Baseline Strategy](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describestrategy)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultBaselineStrategy = new alicloud.threatdetection.BaselineStrategy("default", {
     *     customType: "custom",
     *     endTime: "08:00:00",
     *     baselineStrategyName: "apispec",
     *     cycleDays: 3,
     *     targetType: "groupId",
     *     startTime: "05:00:00",
     *     riskSubTypeName: "hc_exploit_redis",
     * });
     * const default = defaultBaselineStrategy.id.apply(id => alicloud.threatdetection.getBaselineStrategiesOutput({
     *     ids: [id],
     *     nameRegex: defaultBaselineStrategy.name,
     *     customType: "custom",
     * }));
     * export const alicloudThreatDetectionBaselineStrategyExampleId = defaultAlicloudThreatDetectionBaselineStrategys.strategys[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_baseline_strategy = alicloud.threatdetection.BaselineStrategy("default",
     *     custom_type="custom",
     *     end_time="08:00:00",
     *     baseline_strategy_name="apispec",
     *     cycle_days=3,
     *     target_type="groupId",
     *     start_time="05:00:00",
     *     risk_sub_type_name="hc_exploit_redis")
     * default = default_baseline_strategy.id.apply(lambda id: alicloud.threatdetection.get_baseline_strategies_output(ids=[id],
     *     name_regex=default_baseline_strategy.name,
     *     custom_type="custom"))
     * pulumi.export("alicloudThreatDetectionBaselineStrategyExampleId", default_alicloud_threat_detection_baseline_strategys["strategys"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultBaselineStrategy = new AliCloud.ThreatDetection.BaselineStrategy("default", new()
     *     {
     *         CustomType = "custom",
     *         EndTime = "08:00:00",
     *         BaselineStrategyName = "apispec",
     *         CycleDays = 3,
     *         TargetType = "groupId",
     *         StartTime = "05:00:00",
     *         RiskSubTypeName = "hc_exploit_redis",
     *     });
     *     var @default = AliCloud.ThreatDetection.GetBaselineStrategies.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultBaselineStrategy.Id,
     *         },
     *         NameRegex = defaultBaselineStrategy.Name,
     *         CustomType = "custom",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionBaselineStrategyExampleId"] = defaultAlicloudThreatDetectionBaselineStrategys&#46;Strategys[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultBaselineStrategy, err := threatdetection.NewBaselineStrategy(ctx, "default", &threatdetection.BaselineStrategyArgs{
     * 			CustomType:           pulumi.String("custom"),
     * 			EndTime:              pulumi.String("08:00:00"),
     * 			BaselineStrategyName: pulumi.String("apispec"),
     * 			CycleDays:            pulumi.Int(3),
     * 			TargetType:           pulumi.String("groupId"),
     * 			StartTime:            pulumi.String("05:00:00"),
     * 			RiskSubTypeName:      pulumi.String("hc_exploit_redis"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = defaultBaselineStrategy.ID().ApplyT(func(id string) (threatdetection.GetBaselineStrategiesResult, error) {
     * 			return threatdetection.GetBaselineStrategiesResult(interface{}(threatdetection.GetBaselineStrategiesOutput(ctx, threatdetection.GetBaselineStrategiesOutputArgs{
     * 				Ids: []string{
     * 					id,
     * 				},
     * 				NameRegex:  defaultBaselineStrategy.Name,
     * 				CustomType: "custom",
     * 			}, nil))), nil
     * 		}).(threatdetection.GetBaselineStrategiesResultOutput)
     * 		ctx.Export("alicloudThreatDetectionBaselineStrategyExampleId", defaultAlicloudThreatDetectionBaselineStrategys.Strategys[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.BaselineStrategy;
     * import com.pulumi.alicloud.threatdetection.BaselineStrategyArgs;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetBaselineStrategiesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultBaselineStrategy = new BaselineStrategy("defaultBaselineStrategy", BaselineStrategyArgs.builder()
     *             .customType("custom")
     *             .endTime("08:00:00")
     *             .baselineStrategyName("apispec")
     *             .cycleDays(3)
     *             .targetType("groupId")
     *             .startTime("05:00:00")
     *             .riskSubTypeName("hc_exploit_redis")
     *             .build());
     *         final var default = ThreatdetectionFunctions.getBaselineStrategies(GetBaselineStrategiesArgs.builder()
     *             .ids(defaultBaselineStrategy.id())
     *             .nameRegex(defaultBaselineStrategy.name())
     *             .customType("custom")
     *             .build());
     *         ctx.export("alicloudThreatDetectionBaselineStrategyExampleId", defaultAlicloudThreatDetectionBaselineStrategys.strategys()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultBaselineStrategy:
     *     type: alicloud:threatdetection:BaselineStrategy
     *     name: default
     *     properties:
     *       customType: custom
     *       endTime: 08:00:00
     *       baselineStrategyName: apispec
     *       cycleDays: 3
     *       targetType: groupId
     *       startTime: 05:00:00
     *       riskSubTypeName: hc_exploit_redis
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getBaselineStrategies
     *       Arguments:
     *         ids:
     *           - ${defaultBaselineStrategy.id}
     *         nameRegex: ${defaultBaselineStrategy.name}
     *         customType: custom
     * outputs:
     *   alicloudThreatDetectionBaselineStrategyExampleId: ${defaultAlicloudThreatDetectionBaselineStrategys.strategys[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBaselineStrategies.
     * @return A collection of values returned by getBaselineStrategies.
     */
    public suspend fun getBaselineStrategies(argument: GetBaselineStrategiesPlainArgs): GetBaselineStrategiesResult =
        getBaselineStrategiesResultToKotlin(getBaselineStrategiesPlain(argument.toJava()).await())

    /**
     * @see [getBaselineStrategies].
     * @param customType The type of policy. Value:-**common**: standard policy-**custom**: custom policy
     * @param ids A list of Baseline Strategy IDs.
     * @param nameRegex A regex string to filter results by Group Metric Rule name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param strategyIds
     * @return A collection of values returned by getBaselineStrategies.
     */
    public suspend fun getBaselineStrategies(
        customType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        strategyIds: String? = null,
    ): GetBaselineStrategiesResult {
        val argument = GetBaselineStrategiesPlainArgs(
            customType = customType,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            strategyIds = strategyIds,
        )
        return getBaselineStrategiesResultToKotlin(getBaselineStrategiesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBaselineStrategies].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetBaselineStrategiesPlainArgs].
     * @return A collection of values returned by getBaselineStrategies.
     */
    public suspend fun getBaselineStrategies(argument: suspend GetBaselineStrategiesPlainArgsBuilder.() -> Unit): GetBaselineStrategiesResult {
        val builder = GetBaselineStrategiesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBaselineStrategiesResultToKotlin(getBaselineStrategiesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Honey Pot available to the user.[What is Honey Pot](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypot)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getHoneyPots({
     *     ids: ["xxxx"],
     *     honeypotName: "tf-example",
     *     nodeId: "a44e1ab3-6945-444c-889d-5bacee7056e8",
     * });
     * export const alicloudThreatDetectionHoneyPotExampleId = _default.then(_default => _default.pots?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_honey_pots(ids=["xxxx"],
     *     honeypot_name="tf-example",
     *     node_id="a44e1ab3-6945-444c-889d-5bacee7056e8")
     * pulumi.export("alicloudThreatDetectionHoneyPotExampleId", default.pots[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetHoneyPots.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "xxxx",
     *         },
     *         HoneypotName = "tf-example",
     *         NodeId = "a44e1ab3-6945-444c-889d-5bacee7056e8",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionHoneyPotExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getHoneyPotsResult => getHoneyPotsResult&#46;Pots[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := threatdetection.GetHoneyPots(ctx, &threatdetection.GetHoneyPotsArgs{
     * 			Ids: []string{
     * 				"xxxx",
     * 			},
     * 			HoneypotName: pulumi.StringRef("tf-example"),
     * 			NodeId:       pulumi.StringRef("a44e1ab3-6945-444c-889d-5bacee7056e8"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudThreatDetectionHoneyPotExampleId", _default.Pots[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetHoneyPotsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getHoneyPots(GetHoneyPotsArgs.builder()
     *             .ids("xxxx")
     *             .honeypotName("tf-example")
     *             .nodeId("a44e1ab3-6945-444c-889d-5bacee7056e8")
     *             .build());
     *         ctx.export("alicloudThreatDetectionHoneyPotExampleId", default_.pots()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getHoneyPots
     *       Arguments:
     *         ids:
     *           - xxxx
     *         honeypotName: tf-example
     *         nodeId: a44e1ab3-6945-444c-889d-5bacee7056e8
     * outputs:
     *   alicloudThreatDetectionHoneyPotExampleId: ${default.pots[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoneyPots.
     * @return A collection of values returned by getHoneyPots.
     */
    public suspend fun getHoneyPots(argument: GetHoneyPotsPlainArgs): GetHoneyPotsResult =
        getHoneyPotsResultToKotlin(getHoneyPotsPlain(argument.toJava()).await())

    /**
     * @see [getHoneyPots].
     * @param honeypotId Honeypot ID.
     * @param honeypotName Honeypot custom name.
     * @param ids A list of Honey Pot IDs.
     * @param nameRegex A regex string to filter results by honey pot name.
     * @param nodeId The ID of the honeypot management node.
     * @param nodeName The name of the honeypot management node.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHoneyPots.
     */
    public suspend fun getHoneyPots(
        honeypotId: String? = null,
        honeypotName: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        nodeId: String? = null,
        nodeName: String? = null,
        outputFile: String? = null,
    ): GetHoneyPotsResult {
        val argument = GetHoneyPotsPlainArgs(
            honeypotId = honeypotId,
            honeypotName = honeypotName,
            ids = ids,
            nameRegex = nameRegex,
            nodeId = nodeId,
            nodeName = nodeName,
            outputFile = outputFile,
        )
        return getHoneyPotsResultToKotlin(getHoneyPotsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoneyPots].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetHoneyPotsPlainArgs].
     * @return A collection of values returned by getHoneyPots.
     */
    public suspend fun getHoneyPots(argument: suspend GetHoneyPotsPlainArgsBuilder.() -> Unit): GetHoneyPotsResult {
        val builder = GetHoneyPotsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoneyPotsResultToKotlin(getHoneyPotsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Honeypot Image available to the user.[What is Honeypot Image](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-listavailablehoneypot)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getHoneypotImages({
     *     ids: ["sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df"],
     *     nameRegex: "^meta",
     * });
     * export const alicloudThreatDetectionHoneypotImageExampleId = _default.then(_default => _default.images?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_honeypot_images(ids=["sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df"],
     *     name_regex="^meta")
     * pulumi.export("alicloudThreatDetectionHoneypotImageExampleId", default.images[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetHoneypotImages.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df",
     *         },
     *         NameRegex = "^meta",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionHoneypotImageExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getHoneypotImagesResult => getHoneypotImagesResult&#46;Images[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := threatdetection.GetHoneypotImages(ctx, &threatdetection.GetHoneypotImagesArgs{
     * 			Ids: []string{
     * 				"sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df",
     * 			},
     * 			NameRegex: pulumi.StringRef("^meta"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudThreatDetectionHoneypotImageExampleId", _default.Images[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getHoneypotImages(GetHoneypotImagesArgs.builder()
     *             .ids("sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df")
     *             .nameRegex("^meta")
     *             .build());
     *         ctx.export("alicloudThreatDetectionHoneypotImageExampleId", default_.images()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getHoneypotImages
     *       Arguments:
     *         ids:
     *           - sha256:02882320c9a55303410127c5dc4ae2dc470150f9d7f2483102d994f5e5f4d9df
     *         nameRegex: ^meta
     * outputs:
     *   alicloudThreatDetectionHoneypotImageExampleId: ${default.images[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoneypotImages.
     * @return A collection of values returned by getHoneypotImages.
     */
    public suspend fun getHoneypotImages(argument: GetHoneypotImagesPlainArgs): GetHoneypotImagesResult =
        getHoneypotImagesResultToKotlin(getHoneypotImagesPlain(argument.toJava()).await())

    /**
     * @see [getHoneypotImages].
     * @param ids A list of Honeypot Image IDs.
     * @param nameRegex A regex string to filter results by Honeypot mirror nam.
     * @param nodeId
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getHoneypotImages.
     */
    public suspend fun getHoneypotImages(
        ids: List<String>? = null,
        nameRegex: String? = null,
        nodeId: String? = null,
        outputFile: String? = null,
    ): GetHoneypotImagesResult {
        val argument = GetHoneypotImagesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            nodeId = nodeId,
            outputFile = outputFile,
        )
        return getHoneypotImagesResultToKotlin(getHoneypotImagesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoneypotImages].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetHoneypotImagesPlainArgs].
     * @return A collection of values returned by getHoneypotImages.
     */
    public suspend fun getHoneypotImages(argument: suspend GetHoneypotImagesPlainArgsBuilder.() -> Unit): GetHoneypotImagesResult {
        val builder = GetHoneypotImagesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoneypotImagesResultToKotlin(getHoneypotImagesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Honeypot Node available to the user.[What is Honeypot Node](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotnode)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getHoneypotNodes({
     *     ids: [defaultAlicloudThreatDetectionHoneypotNode&#46;id],
     * });
     * export const alicloudThreatDetectionHoneypotNodeExampleId = _default.then(_default => _default.nodes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_honeypot_nodes(ids=[default_alicloud_threat_detection_honeypot_node["id"]])
     * pulumi.export("alicloudThreatDetectionHoneypotNodeExampleId", default.nodes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetHoneypotNodes.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudThreatDetectionHoneypotNode.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionHoneypotNodeExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getHoneypotNodesResult => getHoneypotNodesResult&#46;Nodes[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := threatdetection.GetHoneypotNodes(ctx, &threatdetection.GetHoneypotNodesArgs{
     * Ids: interface{}{
     * defaultAlicloudThreatDetectionHoneypotNode.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudThreatDetectionHoneypotNodeExampleId", _default.Nodes[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotNodesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getHoneypotNodes(GetHoneypotNodesArgs.builder()
     *             .ids(defaultAlicloudThreatDetectionHoneypotNode.id())
     *             .build());
     *         ctx.export("alicloudThreatDetectionHoneypotNodeExampleId", default_.nodes()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getHoneypotNodes
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudThreatDetectionHoneypotNode.id}
     * outputs:
     *   alicloudThreatDetectionHoneypotNodeExampleId: ${default.nodes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoneypotNodes.
     * @return A collection of values returned by getHoneypotNodes.
     */
    public suspend fun getHoneypotNodes(argument: GetHoneypotNodesPlainArgs): GetHoneypotNodesResult =
        getHoneypotNodesResultToKotlin(getHoneypotNodesPlain(argument.toJava()).await())

    /**
     * @see [getHoneypotNodes].
     * @param ids A list of Honeypot Node IDs.
     * @param nameRegex A regex string to filter results by Honeypot Node name.
     * @param nodeId Honeypot management node id.
     * @param nodeName The name of the management node.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getHoneypotNodes.
     */
    public suspend fun getHoneypotNodes(
        ids: List<String>? = null,
        nameRegex: String? = null,
        nodeId: String? = null,
        nodeName: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetHoneypotNodesResult {
        val argument = GetHoneypotNodesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            nodeId = nodeId,
            nodeName = nodeName,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getHoneypotNodesResultToKotlin(getHoneypotNodesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoneypotNodes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetHoneypotNodesPlainArgs].
     * @return A collection of values returned by getHoneypotNodes.
     */
    public suspend fun getHoneypotNodes(argument: suspend GetHoneypotNodesPlainArgsBuilder.() -> Unit): GetHoneypotNodesResult {
        val builder = GetHoneypotNodesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoneypotNodesResultToKotlin(getHoneypotNodesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Honeypot Preset available to the user.
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getHoneypotPresets({
     *     ids: [defaultAlicloudThreatDetectionHoneypotPreset&#46;id],
     *     honeypotImageName: "shiro",
     *     nodeId: "example_value",
     *     presetName: "apiapec_test",
     * });
     * export const alicloudThreatDetectionHoneypotPresetExampleId = _default.then(_default => _default.presets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_honeypot_presets(ids=[default_alicloud_threat_detection_honeypot_preset["id"]],
     *     honeypot_image_name="shiro",
     *     node_id="example_value",
     *     preset_name="apiapec_test")
     * pulumi.export("alicloudThreatDetectionHoneypotPresetExampleId", default.presets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetHoneypotPresets.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudThreatDetectionHoneypotPreset.Id,
     *         },
     *         HoneypotImageName = "shiro",
     *         NodeId = "example_value",
     *         PresetName = "apiapec_test",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionHoneypotPresetExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getHoneypotPresetsResult => getHoneypotPresetsResult&#46;Presets[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := threatdetection.GetHoneypotPresets(ctx, &threatdetection.GetHoneypotPresetsArgs{
     * Ids: interface{}{
     * defaultAlicloudThreatDetectionHoneypotPreset.Id,
     * },
     * HoneypotImageName: pulumi.StringRef("shiro"),
     * NodeId: pulumi.StringRef("example_value"),
     * PresetName: pulumi.StringRef("apiapec_test"),
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudThreatDetectionHoneypotPresetExampleId", _default.Presets[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotPresetsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getHoneypotPresets(GetHoneypotPresetsArgs.builder()
     *             .ids(defaultAlicloudThreatDetectionHoneypotPreset.id())
     *             .honeypotImageName("shiro")
     *             .nodeId("example_value")
     *             .presetName("apiapec_test")
     *             .build());
     *         ctx.export("alicloudThreatDetectionHoneypotPresetExampleId", default_.presets()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getHoneypotPresets
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudThreatDetectionHoneypotPreset.id}
     *         honeypotImageName: shiro
     *         nodeId: example_value
     *         presetName: apiapec_test
     * outputs:
     *   alicloudThreatDetectionHoneypotPresetExampleId: ${default.presets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoneypotPresets.
     * @return A collection of values returned by getHoneypotPresets.
     */
    public suspend fun getHoneypotPresets(argument: GetHoneypotPresetsPlainArgs): GetHoneypotPresetsResult =
        getHoneypotPresetsResultToKotlin(getHoneypotPresetsPlain(argument.toJava()).await())

    /**
     * @see [getHoneypotPresets].
     * @param currentPage
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param honeypotImageName Honeypot mirror name
     * @param ids A list of Honeypot Preset IDs.
     * @param lang
     * @param nodeId Unique id of management node
     * @param nodeName
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param presetName Honeypot template custom name
     * @return A collection of values returned by getHoneypotPresets.
     */
    public suspend fun getHoneypotPresets(
        currentPage: Int? = null,
        enableDetails: Boolean? = null,
        honeypotImageName: String? = null,
        ids: List<String>? = null,
        lang: String? = null,
        nodeId: String? = null,
        nodeName: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        presetName: String? = null,
    ): GetHoneypotPresetsResult {
        val argument = GetHoneypotPresetsPlainArgs(
            currentPage = currentPage,
            enableDetails = enableDetails,
            honeypotImageName = honeypotImageName,
            ids = ids,
            lang = lang,
            nodeId = nodeId,
            nodeName = nodeName,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            presetName = presetName,
        )
        return getHoneypotPresetsResultToKotlin(getHoneypotPresetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoneypotPresets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetHoneypotPresetsPlainArgs].
     * @return A collection of values returned by getHoneypotPresets.
     */
    public suspend fun getHoneypotPresets(argument: suspend GetHoneypotPresetsPlainArgsBuilder.() -> Unit): GetHoneypotPresetsResult {
        val builder = GetHoneypotPresetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoneypotPresetsResultToKotlin(getHoneypotPresetsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Honeypot Probe available to the user.[What is Honeypot Probe](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-createhoneypotprobe)
     * > **NOTE:** Available in 1.195.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const config = new pulumi.Config();
     * const name = config.get("name") || "tf-testAccThreatDetectionHoneypotProbe";
     * const defaultHoneypotProbe = new alicloud.threatdetection.HoneypotProbe("default", {
     *     uuid: "e52c7872-29d1-4aa1-9908-0299abd53606",
     *     probeType: "host_probe",
     *     controlNodeId: "e1397077-4941-4b14-b533-ca2bdebd00a3",
     *     ping: true,
     *     honeypotBindLists: [{
     *         bindPortLists: [{
     *             startPort: 80,
     *             endPort: 80,
     *         }],
     *         honeypotId: "4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05",
     *     }],
     *     displayName: name,
     *     arp: true,
     * });
     * const default = alicloud.threatdetection.getHoneypotProbesOutput({
     *     ids: [defaultHoneypotProbe&#46;id],
     *     displayName: name,
     *     probeType: "host_probe",
     *     enableDetails: true,
     * });
     * export const alicloudThreatDetectionHoneypotProbeExampleId = _default.apply(_default => _default.probes?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * config = pulumi.Config()
     * name = config.get("name")
     * if name is None:
     *     name = "tf-testAccThreatDetectionHoneypotProbe"
     * default_honeypot_probe = alicloud.threatdetection.HoneypotProbe("default",
     *     uuid="e52c7872-29d1-4aa1-9908-0299abd53606",
     *     probe_type="host_probe",
     *     control_node_id="e1397077-4941-4b14-b533-ca2bdebd00a3",
     *     ping=True,
     *     honeypot_bind_lists=[{
     *         "bind_port_lists": [{
     *             "start_port": 80,
     *             "end_port": 80,
     *         }],
     *         "honeypot_id": "4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05",
     *     }],
     *     display_name=name,
     *     arp=True)
     * default = alicloud.threatdetection.get_honeypot_probes_output(ids=[default_honeypot_probe&#46;id],
     *     display_name=name,
     *     probe_type="host_probe",
     *     enable_details=True)
     * pulumi.export("alicloudThreatDetectionHoneypotProbeExampleId", default.probes[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var name = config.Get("name") ?? "tf-testAccThreatDetectionHoneypotProbe";
     *     var defaultHoneypotProbe = new AliCloud.ThreatDetection.HoneypotProbe("default", new()
     *     {
     *         Uuid = "e52c7872-29d1-4aa1-9908-0299abd53606",
     *         ProbeType = "host_probe",
     *         ControlNodeId = "e1397077-4941-4b14-b533-ca2bdebd00a3",
     *         Ping = true,
     *         HoneypotBindLists = new[]
     *         {
     *             new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListArgs
     *             {
     *                 BindPortLists = new[]
     *                 {
     *                     new AliCloud.ThreatDetection.Inputs.HoneypotProbeHoneypotBindListBindPortListArgs
     *                     {
     *                         StartPort = 80,
     *                         EndPort = 80,
     *                     },
     *                 },
     *                 HoneypotId = "4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05",
     *             },
     *         },
     *         DisplayName = name,
     *         Arp = true,
     *     });
     *     var @default = AliCloud.ThreatDetection.GetHoneypotProbes.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultHoneypotProbe.Id,
     *         },
     *         DisplayName = name,
     *         ProbeType = "host_probe",
     *         EnableDetails = true,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionHoneypotProbeExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getHoneypotProbesResult => getHoneypotProbesResult&#46;Probes[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * cfg := config.New(ctx, "")
     * name := "tf-testAccThreatDetectionHoneypotProbe";
     * if param := cfg.Get("name"); param != ""{
     * name = param
     * }
     * defaultHoneypotProbe, err := threatdetection.NewHoneypotProbe(ctx, "default", &threatdetection.HoneypotProbeArgs{
     * Uuid: pulumi.String("e52c7872-29d1-4aa1-9908-0299abd53606"),
     * ProbeType: pulumi.String("host_probe"),
     * ControlNodeId: pulumi.String("e1397077-4941-4b14-b533-ca2bdebd00a3"),
     * Ping: pulumi.Bool(true),
     * HoneypotBindLists: threatdetection.HoneypotProbeHoneypotBindListArray{
     * &threatdetection.HoneypotProbeHoneypotBindListArgs{
     * BindPortLists: threatdetection.HoneypotProbeHoneypotBindListBindPortListArray{
     * &threatdetection.HoneypotProbeHoneypotBindListBindPortListArgs{
     * StartPort: pulumi.Int(80),
     * EndPort: pulumi.Int(80),
     * },
     * },
     * HoneypotId: pulumi.String("4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05"),
     * },
     * },
     * DisplayName: pulumi.String(name),
     * Arp: pulumi.Bool(true),
     * })
     * if err != nil {
     * return err
     * }
     * _default := threatdetection.GetHoneypotProbesOutput(ctx, threatdetection.GetHoneypotProbesOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultHoneypotProbe.ID(),
     * },
     * DisplayName: pulumi.String(name),
     * ProbeType: pulumi.String("host_probe"),
     * EnableDetails: pulumi.Bool(true),
     * }, nil);
     * ctx.Export("alicloudThreatDetectionHoneypotProbeExampleId", _default.ApplyT(func(_default threatdetection.GetHoneypotProbesResult) (*string, error) {
     * return &default.Probes[0].Id, nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.HoneypotProbe;
     * import com.pulumi.alicloud.threatdetection.HoneypotProbeArgs;
     * import com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotProbesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var name = config.get("name").orElse("tf-testAccThreatDetectionHoneypotProbe");
     *         var defaultHoneypotProbe = new HoneypotProbe("defaultHoneypotProbe", HoneypotProbeArgs.builder()
     *             .uuid("e52c7872-29d1-4aa1-9908-0299abd53606")
     *             .probeType("host_probe")
     *             .controlNodeId("e1397077-4941-4b14-b533-ca2bdebd00a3")
     *             .ping(true)
     *             .honeypotBindLists(HoneypotProbeHoneypotBindListArgs.builder()
     *                 .bindPortLists(HoneypotProbeHoneypotBindListBindPortListArgs.builder()
     *                     .startPort(80)
     *                     .endPort(80)
     *                     .build())
     *                 .honeypotId("4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05")
     *                 .build())
     *             .displayName(name)
     *             .arp(true)
     *             .build());
     *         final var default = ThreatdetectionFunctions.getHoneypotProbes(GetHoneypotProbesArgs.builder()
     *             .ids(defaultHoneypotProbe.id())
     *             .displayName(name)
     *             .probeType("host_probe")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("alicloudThreatDetectionHoneypotProbeExampleId", default_.applyValue(default_ -> default_.probes()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * configuration:
     *   name:
     *     type: string
     *     default: tf-testAccThreatDetectionHoneypotProbe
     * resources:
     *   defaultHoneypotProbe:
     *     type: alicloud:threatdetection:HoneypotProbe
     *     name: default
     *     properties:
     *       uuid: e52c7872-29d1-4aa1-9908-0299abd53606
     *       probeType: host_probe
     *       controlNodeId: e1397077-4941-4b14-b533-ca2bdebd00a3
     *       ping: true
     *       honeypotBindLists:
     *         - bindPortLists:
     *             - startPort: 80
     *               endPort: 80
     *           honeypotId: 4925bf9784de992ecd017ad051528a03b3927ef814eeff76c2ebb3ab9a84bf05
     *       displayName: ${name}
     *       arp: true
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getHoneypotProbes
     *       Arguments:
     *         ids:
     *           - ${defaultHoneypotProbe.id}
     *         displayName: ${name}
     *         probeType: host_probe
     *         enableDetails: true
     * outputs:
     *   alicloudThreatDetectionHoneypotProbeExampleId: ${default.probes[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoneypotProbes.
     * @return A collection of values returned by getHoneypotProbes.
     */
    public suspend fun getHoneypotProbes(argument: GetHoneypotProbesPlainArgs): GetHoneypotProbesResult =
        getHoneypotProbesResultToKotlin(getHoneypotProbesPlain(argument.toJava()).await())

    /**
     * @see [getHoneypotProbes].
     * @param displayName Probe name
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of Honeypot Probe IDs.
     * @param nameRegex A regex string to filter results by display name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param probeStatus
     * @param probeType Probe type
     * @return A collection of values returned by getHoneypotProbes.
     */
    public suspend fun getHoneypotProbes(
        displayName: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        probeStatus: String? = null,
        probeType: String? = null,
    ): GetHoneypotProbesResult {
        val argument = GetHoneypotProbesPlainArgs(
            displayName = displayName,
            enableDetails = enableDetails,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            probeStatus = probeStatus,
            probeType = probeType,
        )
        return getHoneypotProbesResultToKotlin(getHoneypotProbesPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoneypotProbes].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetHoneypotProbesPlainArgs].
     * @return A collection of values returned by getHoneypotProbes.
     */
    public suspend fun getHoneypotProbes(argument: suspend GetHoneypotProbesPlainArgsBuilder.() -> Unit): GetHoneypotProbesResult {
        val builder = GetHoneypotProbesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoneypotProbesResultToKotlin(getHoneypotProbesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Instance available to the user.[What is Instance](https://www.alibabacloud.com/help/en/security-center/latest/what-is-security-center)
     * > **NOTE:** Available in 1.199.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getInstances({
     *     ids: [defaultAlicloudThreatDetectionInstance&#46;id],
     * });
     * export const alicloudThreatDetectionInstanceExampleId = _default.then(_default => _default.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_instances(ids=[default_alicloud_threat_detection_instance["id"]])
     * pulumi.export("alicloudThreatDetectionInstanceExampleId", default.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudThreatDetectionInstance.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionInstanceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := threatdetection.GetInstances(ctx, &threatdetection.GetInstancesArgs{
     * Ids: interface{}{
     * defaultAlicloudThreatDetectionInstance.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudThreatDetectionInstanceExampleId", _default.Instances[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids(defaultAlicloudThreatDetectionInstance.id())
     *             .build());
     *         ctx.export("alicloudThreatDetectionInstanceExampleId", default_.instances()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getInstances
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudThreatDetectionInstance.id}
     * outputs:
     *   alicloudThreatDetectionInstanceExampleId: ${default.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param ids A list of Instance IDs.
     * @param instanceId The first ID of the resource
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param renewStatus The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        ids: List<String>? = null,
        instanceId: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        renewStatus: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            renewStatus = renewStatus,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open Threat Detection Log Shipper automatically. If the service has been enabled, it will return `Opened`.
     * For information about Threat Detection Log Shipper and how to use it, see [What is Log Shipper](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifyopenlogshipper).
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.threatdetection.getLogShipper({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.threatdetection.get_log_shipper(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.ThreatDetection.GetLogShipper.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := threatdetection.GetLogShipper(ctx, &threatdetection.GetLogShipperArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetLogShipperArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = ThreatdetectionFunctions.getLogShipper(GetLogShipperArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getLogShipper
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLogShipper.
     * @return A collection of values returned by getLogShipper.
     */
    public suspend fun getLogShipper(argument: GetLogShipperPlainArgs): GetLogShipperResult =
        getLogShipperResultToKotlin(getLogShipperPlain(argument.toJava()).await())

    /**
     * @see [getLogShipper].
     * @param enable Setting the value to `On` to enable the service. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Threat Detection Log Shipper that means you have read and agreed the [Threat Detection Log Shipper Terms of Service](https://help.aliyun.com/document_detail/170157.html). The service can not closed once it is opened.
     * @return A collection of values returned by getLogShipper.
     */
    public suspend fun getLogShipper(enable: String? = null): GetLogShipperResult {
        val argument = GetLogShipperPlainArgs(
            enable = enable,
        )
        return getLogShipperResultToKotlin(getLogShipperPlain(argument.toJava()).await())
    }

    /**
     * @see [getLogShipper].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetLogShipperPlainArgs].
     * @return A collection of values returned by getLogShipper.
     */
    public suspend fun getLogShipper(argument: suspend GetLogShipperPlainArgsBuilder.() -> Unit): GetLogShipperResult {
        val builder = GetLogShipperPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLogShipperResultToKotlin(getLogShipperPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Vul Whitelists of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.195.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getVulWhitelists({
     *     ids: ["example_id"],
     * });
     * export const alicloudThreatDetectionVulWhitelistExampleId = _default.then(_default => _default.whitelists?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_vul_whitelists(ids=["example_id"])
     * pulumi.export("alicloudThreatDetectionVulWhitelistExampleId", default.whitelists[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetVulWhitelists.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionVulWhitelistExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getVulWhitelistsResult => getVulWhitelistsResult&#46;Whitelists[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := threatdetection.GetVulWhitelists(ctx, &threatdetection.GetVulWhitelistsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudThreatDetectionVulWhitelistExampleId", _default.Whitelists[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetVulWhitelistsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getVulWhitelists(GetVulWhitelistsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("alicloudThreatDetectionVulWhitelistExampleId", default_.whitelists()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getVulWhitelists
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   alicloudThreatDetectionVulWhitelistExampleId: ${default.whitelists[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVulWhitelists.
     * @return A collection of values returned by getVulWhitelists.
     */
    public suspend fun getVulWhitelists(argument: GetVulWhitelistsPlainArgs): GetVulWhitelistsResult =
        getVulWhitelistsResultToKotlin(getVulWhitelistsPlain(argument.toJava()).await())

    /**
     * @see [getVulWhitelists].
     * @param ids A list of Threat Detection Vul Whitelist IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getVulWhitelists.
     */
    public suspend fun getVulWhitelists(
        ids: List<String>? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetVulWhitelistsResult {
        val argument = GetVulWhitelistsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getVulWhitelistsResultToKotlin(getVulWhitelistsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVulWhitelists].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetVulWhitelistsPlainArgs].
     * @return A collection of values returned by getVulWhitelists.
     */
    public suspend fun getVulWhitelists(argument: suspend GetVulWhitelistsPlainArgsBuilder.() -> Unit): GetVulWhitelistsResult {
        val builder = GetVulWhitelistsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVulWhitelistsResultToKotlin(getVulWhitelistsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Threat Detection Web Lock Config available to the user.[What is Web Lock Config](https://www.alibabacloud.com/help/en/security-center/latest/api-sas-2018-12-03-describeweblockconfiglist)
     * > **NOTE:** Available since v1.195.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.threatdetection.getWebLockConfigs({
     *     ids: [defaultAlicloudThreatDetectionWebLockConfig&#46;id],
     * });
     * export const alicloudThreatDetectionWebLockConfigExampleId = _default.then(_default => _default.configs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.threatdetection.get_web_lock_configs(ids=[default_alicloud_threat_detection_web_lock_config["id"]])
     * pulumi.export("alicloudThreatDetectionWebLockConfigExampleId", default.configs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.ThreatDetection.GetWebLockConfigs.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultAlicloudThreatDetectionWebLockConfig.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudThreatDetectionWebLockConfigExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getWebLockConfigsResult => getWebLockConfigsResult&#46;Configs[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * _default, err := threatdetection.GetWebLockConfigs(ctx, &threatdetection.GetWebLockConfigsArgs{
     * Ids: interface{}{
     * defaultAlicloudThreatDetectionWebLockConfig.Id,
     * },
     * }, nil);
     * if err != nil {
     * return err
     * }
     * ctx.Export("alicloudThreatDetectionWebLockConfigExampleId", _default.Configs[0].Id)
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
     * import com.pulumi.alicloud.threatdetection.inputs.GetWebLockConfigsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = ThreatdetectionFunctions.getWebLockConfigs(GetWebLockConfigsArgs.builder()
     *             .ids(defaultAlicloudThreatDetectionWebLockConfig.id())
     *             .build());
     *         ctx.export("alicloudThreatDetectionWebLockConfigExampleId", default_.configs()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:threatdetection:getWebLockConfigs
     *       Arguments:
     *         ids:
     *           - ${defaultAlicloudThreatDetectionWebLockConfig.id}
     * outputs:
     *   alicloudThreatDetectionWebLockConfigExampleId: ${default.configs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWebLockConfigs.
     * @return A collection of values returned by getWebLockConfigs.
     */
    public suspend fun getWebLockConfigs(argument: GetWebLockConfigsPlainArgs): GetWebLockConfigsResult =
        getWebLockConfigsResultToKotlin(getWebLockConfigsPlain(argument.toJava()).await())

    /**
     * @see [getWebLockConfigs].
     * @param ids A list of Web Lock Config IDs.
     * @param lang The language of the content within the request and the response. Valid values: `zh`, `en`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @param remark The string that allows you to search for servers in fuzzy match mode. You can enter a server name or IP address.
     * @param sourceIp The source IP address of the request.
     * @param status The protection status of the server that you want to query. Valid values: `on`, `off`.
     * @return A collection of values returned by getWebLockConfigs.
     */
    public suspend fun getWebLockConfigs(
        ids: List<String>? = null,
        lang: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
        remark: String? = null,
        sourceIp: String? = null,
        status: String? = null,
    ): GetWebLockConfigsResult {
        val argument = GetWebLockConfigsPlainArgs(
            ids = ids,
            lang = lang,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
            remark = remark,
            sourceIp = sourceIp,
            status = status,
        )
        return getWebLockConfigsResultToKotlin(getWebLockConfigsPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebLockConfigs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;threatdetection&#46;kotlin&#46;inputs&#46;GetWebLockConfigsPlainArgs].
     * @return A collection of values returned by getWebLockConfigs.
     */
    public suspend fun getWebLockConfigs(argument: suspend GetWebLockConfigsPlainArgsBuilder.() -> Unit): GetWebLockConfigsResult {
        val builder = GetWebLockConfigsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebLockConfigsResultToKotlin(getWebLockConfigsPlain(builtArgument.toJava()).await())
    }
}
