@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VulWhitelist].
 */
@PulumiTagMarker
public class VulWhitelistResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VulWhitelistArgs = VulWhitelistArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VulWhitelistArgsBuilder.() -> Unit) {
        val builder = VulWhitelistArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VulWhitelist {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.VulWhitelist(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VulWhitelist(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Vul Whitelist resource.
 * For information about Threat Detection Vul Whitelist and how to use it, see [What is Vul Whitelist](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.VulWhitelist("default", {
 *     whitelist: "[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *     targetInfo: "{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *     reason: "tf-example-reason",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.VulWhitelist("default",
 *     whitelist="[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *     target_info="{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *     reason="tf-example-reason")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.VulWhitelist("default", new()
 *     {
 *         Whitelist = "[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *         TargetInfo = "{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *         Reason = "tf-example-reason",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewVulWhitelist(ctx, "default", &threatdetection.VulWhitelistArgs{
 * 			Whitelist:  pulumi.String("[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]"),
 * 			TargetInfo: pulumi.String("{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}"),
 * 			Reason:     pulumi.String("tf-example-reason"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.VulWhitelist;
 * import com.pulumi.alicloud.threatdetection.VulWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VulWhitelist("default", VulWhitelistArgs.builder()
 *             .whitelist("[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]")
 *             .targetInfo("{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}")
 *             .reason("tf-example-reason")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:VulWhitelist
 *     properties:
 *       whitelist: '[{"aliasName":"RHSA-2021:2260: libwebp 安全更新","name":"RHSA-2021:2260: libwebp 安全更新","type":"cve"}]'
 *       targetInfo: '{"type":"GroupId","uuids":[],"groupIds":[10782678]}'
 *       reason: tf-example-reason
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Vul Whitelist can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/vulWhitelist:VulWhitelist example <id>
 * ```
 */
public class VulWhitelist internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.VulWhitelist,
) : KotlinCustomResource(javaResource, VulWhitelistMapper) {
    /**
     * Reason for adding whitelist.
     */
    public val reason: Output<String>?
        get() = javaResource.reason().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Set the effective range of the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    public val targetInfo: Output<String>?
        get() = javaResource.targetInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the vulnerability to be added to the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    public val whitelist: Output<String>
        get() = javaResource.whitelist().applyValue({ args0 -> args0 })
}

public object VulWhitelistMapper : ResourceMapper<VulWhitelist> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.VulWhitelist::class == javaResource::class

    override fun map(javaResource: Resource): VulWhitelist = VulWhitelist(
        javaResource as
            com.pulumi.alicloud.threatdetection.VulWhitelist,
    )
}

/**
 * @see [VulWhitelist].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VulWhitelist].
 */
public suspend fun vulWhitelist(
    name: String,
    block: suspend VulWhitelistResourceBuilder.() -> Unit,
): VulWhitelist {
    val builder = VulWhitelistResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VulWhitelist].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vulWhitelist(name: String): VulWhitelist {
    val builder = VulWhitelistResourceBuilder()
    builder.name(name)
    return builder.build()
}
