@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.VulWhitelistArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Vul Whitelist resource.
 * For information about Threat Detection Vul Whitelist and how to use it, see [What is Vul Whitelist](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.threatdetection.VulWhitelist("default", {
 *     whitelist: "[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *     targetInfo: "{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *     reason: "tf-example-reason",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.VulWhitelist("default",
 *     whitelist="[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *     target_info="{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *     reason="tf-example-reason")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.ThreatDetection.VulWhitelist("default", new()
 *     {
 *         Whitelist = "[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]",
 *         TargetInfo = "{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}",
 *         Reason = "tf-example-reason",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := threatdetection.NewVulWhitelist(ctx, "default", &threatdetection.VulWhitelistArgs{
 * 			Whitelist:  pulumi.String("[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]"),
 * 			TargetInfo: pulumi.String("{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}"),
 * 			Reason:     pulumi.String("tf-example-reason"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.VulWhitelist;
 * import com.pulumi.alicloud.threatdetection.VulWhitelistArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new VulWhitelist("default", VulWhitelistArgs.builder()
 *             .whitelist("[{\"aliasName\":\"RHSA-2021:2260: libwebp 安全更新\",\"name\":\"RHSA-2021:2260: libwebp 安全更新\",\"type\":\"cve\"}]")
 *             .targetInfo("{\"type\":\"GroupId\",\"uuids\":[],\"groupIds\":[10782678]}")
 *             .reason("tf-example-reason")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:threatdetection:VulWhitelist
 *     properties:
 *       whitelist: '[{"aliasName":"RHSA-2021:2260: libwebp 安全更新","name":"RHSA-2021:2260: libwebp 安全更新","type":"cve"}]'
 *       targetInfo: '{"type":"GroupId","uuids":[],"groupIds":[10782678]}'
 *       reason: tf-example-reason
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Vul Whitelist can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/vulWhitelist:VulWhitelist example <id>
 * ```
 * @property reason Reason for adding whitelist.
 * @property targetInfo Set the effective range of the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
 * @property whitelist Information about the vulnerability to be added to the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
 */
public data class VulWhitelistArgs(
    public val reason: Output<String>? = null,
    public val targetInfo: Output<String>? = null,
    public val whitelist: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.VulWhitelistArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.VulWhitelistArgs =
        com.pulumi.alicloud.threatdetection.VulWhitelistArgs.builder()
            .reason(reason?.applyValue({ args0 -> args0 }))
            .targetInfo(targetInfo?.applyValue({ args0 -> args0 }))
            .whitelist(whitelist?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VulWhitelistArgs].
 */
@PulumiTagMarker
public class VulWhitelistArgsBuilder internal constructor() {
    private var reason: Output<String>? = null

    private var targetInfo: Output<String>? = null

    private var whitelist: Output<String>? = null

    /**
     * @param value Reason for adding whitelist.
     */
    @JvmName("nitynaeqyhjjnrju")
    public suspend fun reason(`value`: Output<String>) {
        this.reason = value
    }

    /**
     * @param value Set the effective range of the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    @JvmName("nsntalatysufuwxj")
    public suspend fun targetInfo(`value`: Output<String>) {
        this.targetInfo = value
    }

    /**
     * @param value Information about the vulnerability to be added to the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    @JvmName("ijaaebjorbpamnvc")
    public suspend fun whitelist(`value`: Output<String>) {
        this.whitelist = value
    }

    /**
     * @param value Reason for adding whitelist.
     */
    @JvmName("apbpebacgwdgycck")
    public suspend fun reason(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reason = mapped
    }

    /**
     * @param value Set the effective range of the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    @JvmName("gguflnaoxcjcgudo")
    public suspend fun targetInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetInfo = mapped
    }

    /**
     * @param value Information about the vulnerability to be added to the whitelist. see [how to use it](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifycreatevulwhitelist).
     */
    @JvmName("dgowirbqrwfvofmx")
    public suspend fun whitelist(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whitelist = mapped
    }

    internal fun build(): VulWhitelistArgs = VulWhitelistArgs(
        reason = reason,
        targetInfo = targetInfo,
        whitelist = whitelist,
    )
}
