@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebLockConfig].
 */
@PulumiTagMarker
public class WebLockConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebLockConfigArgs = WebLockConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebLockConfigArgsBuilder.() -> Unit) {
        val builder = WebLockConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebLockConfig {
        val builtJavaResource =
            com.pulumi.alicloud.threatdetection.WebLockConfig(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebLockConfig(builtJavaResource)
    }
}

/**
 * Provides a Threat Detection Web Lock Config resource.
 * For information about Threat Detection Web Lock Config and how to use it, see [What is Web Lock Config](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifyweblockstart).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.threatdetection.getAssets({
 *     machineTypes: "ecs",
 * });
 * const defaultWebLockConfig = new alicloud.threatdetection.WebLockConfig("default", {
 *     inclusiveFileType: "php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *     uuid: _default.then(_default => _default.ids?.[0]),
 *     mode: "whitelist",
 *     localBackupDir: "/usr/local/aegis/bak",
 *     dir: "/tmp/",
 *     defenceMode: "audit",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.get_assets(machine_types="ecs")
 * default_web_lock_config = alicloud.threatdetection.WebLockConfig("default",
 *     inclusive_file_type="php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *     uuid=default.ids[0],
 *     mode="whitelist",
 *     local_backup_dir="/usr/local/aegis/bak",
 *     dir="/tmp/",
 *     defence_mode="audit")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ThreatDetection.GetAssets.Invoke(new()
 *     {
 *         MachineTypes = "ecs",
 *     });
 *     var defaultWebLockConfig = new AliCloud.ThreatDetection.WebLockConfig("default", new()
 *     {
 *         InclusiveFileType = "php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *         Uuid = @default.Apply(@default => @default.Apply(getAssetsResult => getAssetsResult.Ids[0])),
 *         Mode = "whitelist",
 *         LocalBackupDir = "/usr/local/aegis/bak",
 *         Dir = "/tmp/",
 *         DefenceMode = "audit",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := threatdetection.GetAssets(ctx, &threatdetection.GetAssetsArgs{
 * 			MachineTypes: pulumi.StringRef("ecs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewWebLockConfig(ctx, "default", &threatdetection.WebLockConfigArgs{
 * 			InclusiveFileType: pulumi.String("php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg"),
 * 			Uuid:              pulumi.String(_default.Ids[0]),
 * 			Mode:              pulumi.String("whitelist"),
 * 			LocalBackupDir:    pulumi.String("/usr/local/aegis/bak"),
 * 			Dir:               pulumi.String("/tmp/"),
 * 			DefenceMode:       pulumi.String("audit"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetAssetsArgs;
 * import com.pulumi.alicloud.threatdetection.WebLockConfig;
 * import com.pulumi.alicloud.threatdetection.WebLockConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ThreatdetectionFunctions.getAssets(GetAssetsArgs.builder()
 *             .machineTypes("ecs")
 *             .build());
 *         var defaultWebLockConfig = new WebLockConfig("defaultWebLockConfig", WebLockConfigArgs.builder()
 *             .inclusiveFileType("php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg")
 *             .uuid(default_.ids()[0])
 *             .mode("whitelist")
 *             .localBackupDir("/usr/local/aegis/bak")
 *             .dir("/tmp/")
 *             .defenceMode("audit")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultWebLockConfig:
 *     type: alicloud:threatdetection:WebLockConfig
 *     name: default
 *     properties:
 *       inclusiveFileType: php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg
 *       uuid: ${default.ids[0]}
 *       mode: whitelist
 *       localBackupDir: /usr/local/aegis/bak
 *       dir: /tmp/
 *       defenceMode: audit
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getAssets
 *       Arguments:
 *         machineTypes: ecs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Web Lock Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/webLockConfig:WebLockConfig example <id>
 * ```
 */
public class WebLockConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.threatdetection.WebLockConfig,
) : KotlinCustomResource(javaResource, WebLockConfigMapper) {
    /**
     * Protection mode. Value:-**block**: Intercept-**audit**: Alarm
     */
    public val defenceMode: Output<String>
        get() = javaResource.defenceMode().applyValue({ args0 -> args0 })

    /**
     * Specify the protection directory.
     */
    public val dir: Output<String>
        get() = javaResource.dir().applyValue({ args0 -> args0 })

    /**
     * Specify a directory address that does not require Web tamper protection (I. E. Excluded directories).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    public val exclusiveDir: Output<String>?
        get() = javaResource.exclusiveDir().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify files that do not need to enable tamper protection for web pages (that is, exclude files).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    public val exclusiveFile: Output<String>?
        get() = javaResource.exclusiveFile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify the type of file that does not require Web tamper protection (that is, the type of excluded file). When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png > The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    public val exclusiveFileType: Output<String>?
        get() = javaResource.exclusiveFileType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify the type of file that requires tamper protection. When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png> The protection Mode **Mode** is set to **whitelist**, you need to configure this parameter.
     */
    public val inclusiveFileType: Output<String>?
        get() = javaResource.inclusiveFileType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The local backup path is used to protect the safe backup of the Directory.
     */
    public val localBackupDir: Output<String>
        get() = javaResource.localBackupDir().applyValue({ args0 -> args0 })

    /**
     * Specify the protected directory mode. Value:-**whitelist**: whitelist mode, which protects the added protected directories and file types.-**blacklist**: blacklist mode, which protects all unexcluded subdirectories, file types, and specified files under the added protection directory.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * Specify the UUID of the server to which you want to add a protection directory.> You can call the DescribeCloudCenterInstances interface to obtain the UUID of the server.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object WebLockConfigMapper : ResourceMapper<WebLockConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.threatdetection.WebLockConfig::class == javaResource::class

    override fun map(javaResource: Resource): WebLockConfig = WebLockConfig(
        javaResource as
            com.pulumi.alicloud.threatdetection.WebLockConfig,
    )
}

/**
 * @see [WebLockConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebLockConfig].
 */
public suspend fun webLockConfig(
    name: String,
    block: suspend WebLockConfigResourceBuilder.() -> Unit,
): WebLockConfig {
    val builder = WebLockConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebLockConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webLockConfig(name: String): WebLockConfig {
    val builder = WebLockConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
