@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin

import com.pulumi.alicloud.threatdetection.WebLockConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Threat Detection Web Lock Config resource.
 * For information about Threat Detection Web Lock Config and how to use it, see [What is Web Lock Config](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-modifyweblockstart).
 * > **NOTE:** Available in v1.195.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.threatdetection.getAssets({
 *     machineTypes: "ecs",
 * });
 * const defaultWebLockConfig = new alicloud.threatdetection.WebLockConfig("default", {
 *     inclusiveFileType: "php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *     uuid: _default.then(_default => _default.ids?.[0]),
 *     mode: "whitelist",
 *     localBackupDir: "/usr/local/aegis/bak",
 *     dir: "/tmp/",
 *     defenceMode: "audit",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.threatdetection.get_assets(machine_types="ecs")
 * default_web_lock_config = alicloud.threatdetection.WebLockConfig("default",
 *     inclusive_file_type="php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *     uuid=default.ids[0],
 *     mode="whitelist",
 *     local_backup_dir="/usr/local/aegis/bak",
 *     dir="/tmp/",
 *     defence_mode="audit")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.ThreatDetection.GetAssets.Invoke(new()
 *     {
 *         MachineTypes = "ecs",
 *     });
 *     var defaultWebLockConfig = new AliCloud.ThreatDetection.WebLockConfig("default", new()
 *     {
 *         InclusiveFileType = "php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg",
 *         Uuid = @default.Apply(@default => @default.Apply(getAssetsResult => getAssetsResult.Ids[0])),
 *         Mode = "whitelist",
 *         LocalBackupDir = "/usr/local/aegis/bak",
 *         Dir = "/tmp/",
 *         DefenceMode = "audit",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/threatdetection"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := threatdetection.GetAssets(ctx, &threatdetection.GetAssetsArgs{
 * 			MachineTypes: pulumi.StringRef("ecs"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = threatdetection.NewWebLockConfig(ctx, "default", &threatdetection.WebLockConfigArgs{
 * 			InclusiveFileType: pulumi.String("php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg"),
 * 			Uuid:              pulumi.String(_default.Ids[0]),
 * 			Mode:              pulumi.String("whitelist"),
 * 			LocalBackupDir:    pulumi.String("/usr/local/aegis/bak"),
 * 			Dir:               pulumi.String("/tmp/"),
 * 			DefenceMode:       pulumi.String("audit"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.threatdetection.ThreatdetectionFunctions;
 * import com.pulumi.alicloud.threatdetection.inputs.GetAssetsArgs;
 * import com.pulumi.alicloud.threatdetection.WebLockConfig;
 * import com.pulumi.alicloud.threatdetection.WebLockConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = ThreatdetectionFunctions.getAssets(GetAssetsArgs.builder()
 *             .machineTypes("ecs")
 *             .build());
 *         var defaultWebLockConfig = new WebLockConfig("defaultWebLockConfig", WebLockConfigArgs.builder()
 *             .inclusiveFileType("php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg")
 *             .uuid(default_.ids()[0])
 *             .mode("whitelist")
 *             .localBackupDir("/usr/local/aegis/bak")
 *             .dir("/tmp/")
 *             .defenceMode("audit")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultWebLockConfig:
 *     type: alicloud:threatdetection:WebLockConfig
 *     name: default
 *     properties:
 *       inclusiveFileType: php;jsp;asp;aspx;js;cgi;html;htm;xml;shtml;shtm;jpg
 *       uuid: ${default.ids[0]}
 *       mode: whitelist
 *       localBackupDir: /usr/local/aegis/bak
 *       dir: /tmp/
 *       defenceMode: audit
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:threatdetection:getAssets
 *       Arguments:
 *         machineTypes: ecs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Threat Detection Web Lock Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:threatdetection/webLockConfig:WebLockConfig example <id>
 * ```
 * @property defenceMode Protection mode. Value:-**block**: Intercept-**audit**: Alarm
 * @property dir Specify the protection directory.
 * @property exclusiveDir Specify a directory address that does not require Web tamper protection (I. E. Excluded directories).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
 * @property exclusiveFile Specify files that do not need to enable tamper protection for web pages (that is, exclude files).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
 * @property exclusiveFileType Specify the type of file that does not require Web tamper protection (that is, the type of excluded file). When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png > The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
 * @property inclusiveFileType Specify the type of file that requires tamper protection. When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png> The protection Mode **Mode** is set to **whitelist**, you need to configure this parameter.
 * @property localBackupDir The local backup path is used to protect the safe backup of the Directory.
 * @property mode Specify the protected directory mode. Value:-**whitelist**: whitelist mode, which protects the added protected directories and file types.-**blacklist**: blacklist mode, which protects all unexcluded subdirectories, file types, and specified files under the added protection directory.
 * @property uuid Specify the UUID of the server to which you want to add a protection directory.> You can call the DescribeCloudCenterInstances interface to obtain the UUID of the server.
 */
public data class WebLockConfigArgs(
    public val defenceMode: Output<String>? = null,
    public val dir: Output<String>? = null,
    public val exclusiveDir: Output<String>? = null,
    public val exclusiveFile: Output<String>? = null,
    public val exclusiveFileType: Output<String>? = null,
    public val inclusiveFileType: Output<String>? = null,
    public val localBackupDir: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val uuid: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.WebLockConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.WebLockConfigArgs =
        com.pulumi.alicloud.threatdetection.WebLockConfigArgs.builder()
            .defenceMode(defenceMode?.applyValue({ args0 -> args0 }))
            .dir(dir?.applyValue({ args0 -> args0 }))
            .exclusiveDir(exclusiveDir?.applyValue({ args0 -> args0 }))
            .exclusiveFile(exclusiveFile?.applyValue({ args0 -> args0 }))
            .exclusiveFileType(exclusiveFileType?.applyValue({ args0 -> args0 }))
            .inclusiveFileType(inclusiveFileType?.applyValue({ args0 -> args0 }))
            .localBackupDir(localBackupDir?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .uuid(uuid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebLockConfigArgs].
 */
@PulumiTagMarker
public class WebLockConfigArgsBuilder internal constructor() {
    private var defenceMode: Output<String>? = null

    private var dir: Output<String>? = null

    private var exclusiveDir: Output<String>? = null

    private var exclusiveFile: Output<String>? = null

    private var exclusiveFileType: Output<String>? = null

    private var inclusiveFileType: Output<String>? = null

    private var localBackupDir: Output<String>? = null

    private var mode: Output<String>? = null

    private var uuid: Output<String>? = null

    /**
     * @param value Protection mode. Value:-**block**: Intercept-**audit**: Alarm
     */
    @JvmName("qlpypppunsvapagg")
    public suspend fun defenceMode(`value`: Output<String>) {
        this.defenceMode = value
    }

    /**
     * @param value Specify the protection directory.
     */
    @JvmName("rxyovogaunwewtlo")
    public suspend fun dir(`value`: Output<String>) {
        this.dir = value
    }

    /**
     * @param value Specify a directory address that does not require Web tamper protection (I. E. Excluded directories).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("blbsvwydfttrnmll")
    public suspend fun exclusiveDir(`value`: Output<String>) {
        this.exclusiveDir = value
    }

    /**
     * @param value Specify files that do not need to enable tamper protection for web pages (that is, exclude files).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("qoruspilbbhmdqlx")
    public suspend fun exclusiveFile(`value`: Output<String>) {
        this.exclusiveFile = value
    }

    /**
     * @param value Specify the type of file that does not require Web tamper protection (that is, the type of excluded file). When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png > The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("fdlxshhkchlxqhpg")
    public suspend fun exclusiveFileType(`value`: Output<String>) {
        this.exclusiveFileType = value
    }

    /**
     * @param value Specify the type of file that requires tamper protection. When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png> The protection Mode **Mode** is set to **whitelist**, you need to configure this parameter.
     */
    @JvmName("rfojmkgllifyxqya")
    public suspend fun inclusiveFileType(`value`: Output<String>) {
        this.inclusiveFileType = value
    }

    /**
     * @param value The local backup path is used to protect the safe backup of the Directory.
     */
    @JvmName("kxurkjwqnjpjgbdq")
    public suspend fun localBackupDir(`value`: Output<String>) {
        this.localBackupDir = value
    }

    /**
     * @param value Specify the protected directory mode. Value:-**whitelist**: whitelist mode, which protects the added protected directories and file types.-**blacklist**: blacklist mode, which protects all unexcluded subdirectories, file types, and specified files under the added protection directory.
     */
    @JvmName("lqvpnrrnbabybftc")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Specify the UUID of the server to which you want to add a protection directory.> You can call the DescribeCloudCenterInstances interface to obtain the UUID of the server.
     */
    @JvmName("viqjolffgdstirld")
    public suspend fun uuid(`value`: Output<String>) {
        this.uuid = value
    }

    /**
     * @param value Protection mode. Value:-**block**: Intercept-**audit**: Alarm
     */
    @JvmName("hwreqdilvcfbcnat")
    public suspend fun defenceMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenceMode = mapped
    }

    /**
     * @param value Specify the protection directory.
     */
    @JvmName("xhpljxdrujqtnmiu")
    public suspend fun dir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dir = mapped
    }

    /**
     * @param value Specify a directory address that does not require Web tamper protection (I. E. Excluded directories).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("jaqndvgdsicgjwfw")
    public suspend fun exclusiveDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveDir = mapped
    }

    /**
     * @param value Specify files that do not need to enable tamper protection for web pages (that is, exclude files).> The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("ykxsesdbqqjlrubj")
    public suspend fun exclusiveFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveFile = mapped
    }

    /**
     * @param value Specify the type of file that does not require Web tamper protection (that is, the type of excluded file). When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png > The protection Mode **Mode** is set to **blacklist**, you need to configure this parameter.
     */
    @JvmName("mmrxaxnrrtopxhwv")
    public suspend fun exclusiveFileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveFileType = mapped
    }

    /**
     * @param value Specify the type of file that requires tamper protection. When there are multiple file types, use semicolons (;) separation. Value:-php-jsp-asp-aspx-js-cgi-html-htm-xml-shtml-shtm-jpg-gif-png> The protection Mode **Mode** is set to **whitelist**, you need to configure this parameter.
     */
    @JvmName("wobongujymuwdexs")
    public suspend fun inclusiveFileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inclusiveFileType = mapped
    }

    /**
     * @param value The local backup path is used to protect the safe backup of the Directory.
     */
    @JvmName("tgfqhgoafmdsdkgj")
    public suspend fun localBackupDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBackupDir = mapped
    }

    /**
     * @param value Specify the protected directory mode. Value:-**whitelist**: whitelist mode, which protects the added protected directories and file types.-**blacklist**: blacklist mode, which protects all unexcluded subdirectories, file types, and specified files under the added protection directory.
     */
    @JvmName("ofhlpptvnuyuobjl")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Specify the UUID of the server to which you want to add a protection directory.> You can call the DescribeCloudCenterInstances interface to obtain the UUID of the server.
     */
    @JvmName("gtdhabxlflxmosws")
    public suspend fun uuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuid = mapped
    }

    internal fun build(): WebLockConfigArgs = WebLockConfigArgs(
        defenceMode = defenceMode,
        dir = dir,
        exclusiveDir = exclusiveDir,
        exclusiveFile = exclusiveFile,
        exclusiveFileType = exclusiveFileType,
        inclusiveFileType = inclusiveFileType,
        localBackupDir = localBackupDir,
        mode = mode,
        uuid = uuid,
    )
}
