@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetAssetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAssets.
 * @property criteria Set the conditions for searching assets. This parameter is in JSON format. Note the case when you enter the parameter. **NOTE:** You can search for assets by using conditions such as the instance ID, instance name, VPC ID, region, and public IP address of the asset.
 * @property ids A list of Asset IDs.
 * @property importance Set asset importance. Value:
 * - **2**: Significant assets
 * - **1**: General assets
 * - **0**: Test asset
 * @property logicalExp Set the logical relationship between multiple search conditions. The default value is **OR**. Valid values:
 * - **OR**: indicates that the relationship between multiple search conditions is **OR**.
 * - **AND**: indicates that the relationship between multiple search conditions is **AND**.
 * @property machineTypes The type of asset to query. Value:
 * - **ecs**: server.
 * - **cloud_product**: Cloud product.
 * @property noGroupTrace Specifies whether to internationalize the name of the default group. Default value: false
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetAssetsPlainArgs(
    public val criteria: String? = null,
    public val ids: List<String>? = null,
    public val importance: Int? = null,
    public val logicalExp: String? = null,
    public val machineTypes: String? = null,
    public val noGroupTrace: Boolean? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetAssetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetAssetsPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetAssetsPlainArgs.builder()
            .criteria(criteria?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .importance(importance?.let({ args0 -> args0 }))
            .logicalExp(logicalExp?.let({ args0 -> args0 }))
            .machineTypes(machineTypes?.let({ args0 -> args0 }))
            .noGroupTrace(noGroupTrace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssetsPlainArgs].
 */
@PulumiTagMarker
public class GetAssetsPlainArgsBuilder internal constructor() {
    private var criteria: String? = null

    private var ids: List<String>? = null

    private var importance: Int? = null

    private var logicalExp: String? = null

    private var machineTypes: String? = null

    private var noGroupTrace: Boolean? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value Set the conditions for searching assets. This parameter is in JSON format. Note the case when you enter the parameter. **NOTE:** You can search for assets by using conditions such as the instance ID, instance name, VPC ID, region, and public IP address of the asset.
     */
    @JvmName("nxdhwlwbxjolpndk")
    public suspend fun criteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.criteria = mapped
    }

    /**
     * @param value A list of Asset IDs.
     */
    @JvmName("pyirassywerwubul")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Asset IDs.
     */
    @JvmName("vjacidpmkfddvxaf")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Set asset importance. Value:
     * - **2**: Significant assets
     * - **1**: General assets
     * - **0**: Test asset
     */
    @JvmName("hqjmhmqjisbwglnt")
    public suspend fun importance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.importance = mapped
    }

    /**
     * @param value Set the logical relationship between multiple search conditions. The default value is **OR**. Valid values:
     * - **OR**: indicates that the relationship between multiple search conditions is **OR**.
     * - **AND**: indicates that the relationship between multiple search conditions is **AND**.
     */
    @JvmName("wqpdeioylyacueas")
    public suspend fun logicalExp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.logicalExp = mapped
    }

    /**
     * @param value The type of asset to query. Value:
     * - **ecs**: server.
     * - **cloud_product**: Cloud product.
     */
    @JvmName("xcnbxdabtmetkkgl")
    public suspend fun machineTypes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.machineTypes = mapped
    }

    /**
     * @param value Specifies whether to internationalize the name of the default group. Default value: false
     */
    @JvmName("bulbbjpqumvmkhod")
    public suspend fun noGroupTrace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.noGroupTrace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jmfgdfxwhmuioejj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("oiotjklkkbebxpfx")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("twvwevnywetqhbkk")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetAssetsPlainArgs = GetAssetsPlainArgs(
        criteria = criteria,
        ids = ids,
        importance = importance,
        logicalExp = logicalExp,
        machineTypes = machineTypes,
        noGroupTrace = noGroupTrace,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
