@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetBackupPoliciesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackupPolicies.
 * @property currentPage
 * @property ids A list of Threat Detection Backup Policies IDs.
 * @property machineRemark The information that you want to use to identify the servers protected by the anti-ransomware policy. You can enter the IP address or ID of a server.
 * @property name The name of the anti-ransomware policy that you want to query.
 * @property nameRegex A regex string to filter results by Threat Detection Backup Policies name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageSize
 * @property status The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
 */
public data class GetBackupPoliciesPlainArgs(
    public val currentPage: Int? = null,
    public val ids: List<String>? = null,
    public val machineRemark: String? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetBackupPoliciesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetBackupPoliciesPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetBackupPoliciesPlainArgs.builder()
            .currentPage(currentPage?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .machineRemark(machineRemark?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPoliciesPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPoliciesPlainArgsBuilder internal constructor() {
    private var currentPage: Int? = null

    private var ids: List<String>? = null

    private var machineRemark: String? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageSize: Int? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("ffudneauxlaujjss")
    public suspend fun currentPage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.currentPage = mapped
    }

    /**
     * @param value A list of Threat Detection Backup Policies IDs.
     */
    @JvmName("jhjwipivspyhlqcm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Threat Detection Backup Policies IDs.
     */
    @JvmName("glugrnkmiywmvxga")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The information that you want to use to identify the servers protected by the anti-ransomware policy. You can enter the IP address or ID of a server.
     */
    @JvmName("wwumlaigviqudnjt")
    public suspend fun machineRemark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.machineRemark = mapped
    }

    /**
     * @param value The name of the anti-ransomware policy that you want to query.
     */
    @JvmName("gstxaegqojgkfrbx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Threat Detection Backup Policies name.
     */
    @JvmName("lhayfnrkwmtxnwcy")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jrveufkhobxrfkdq")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("oirlpaxruaaqdffq")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
     */
    @JvmName("bfytorejmpiojxti")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBackupPoliciesPlainArgs = GetBackupPoliciesPlainArgs(
        currentPage = currentPage,
        ids = ids,
        machineRemark = machineRemark,
        name = name,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageSize = pageSize,
        status = status,
    )
}
