@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetBaselineStrategiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBaselineStrategies.
 * @property customType The type of policy. Value:-**common**: standard policy-**custom**: custom policy
 * @property ids A list of Baseline Strategy IDs.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property strategyIds
 */
public data class GetBaselineStrategiesPlainArgs(
    public val customType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val strategyIds: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetBaselineStrategiesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetBaselineStrategiesPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetBaselineStrategiesPlainArgs.builder()
            .customType(customType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .strategyIds(strategyIds?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBaselineStrategiesPlainArgs].
 */
@PulumiTagMarker
public class GetBaselineStrategiesPlainArgsBuilder internal constructor() {
    private var customType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var strategyIds: String? = null

    /**
     * @param value The type of policy. Value:-**common**: standard policy-**custom**: custom policy
     */
    @JvmName("sltpqtwbwvqxaprn")
    public suspend fun customType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customType = mapped
    }

    /**
     * @param value A list of Baseline Strategy IDs.
     */
    @JvmName("iodnkuvvafuhsecn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Baseline Strategy IDs.
     */
    @JvmName("fcjrexcksrpwfxjt")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("aybbqggyygpdubcq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bgynluslgmfvnpgl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("drfihrltugdrcuvu")
    public suspend fun strategyIds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.strategyIds = mapped
    }

    internal fun build(): GetBaselineStrategiesPlainArgs = GetBaselineStrategiesPlainArgs(
        customType = customType,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        strategyIds = strategyIds,
    )
}
