@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetHoneyPotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoneyPots.
 * @property honeypotId Honeypot ID.
 * @property honeypotName Honeypot custom name.
 * @property ids A list of Honey Pot IDs.
 * @property nameRegex A regex string to filter results by honey pot name.
 * @property nodeId The ID of the honeypot management node.
 * @property nodeName The name of the honeypot management node.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetHoneyPotsPlainArgs(
    public val honeypotId: String? = null,
    public val honeypotName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetHoneyPotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetHoneyPotsPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetHoneyPotsPlainArgs.builder()
            .honeypotId(honeypotId?.let({ args0 -> args0 }))
            .honeypotName(honeypotName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .nodeName(nodeName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHoneyPotsPlainArgs].
 */
@PulumiTagMarker
public class GetHoneyPotsPlainArgsBuilder internal constructor() {
    private var honeypotId: String? = null

    private var honeypotName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var nodeId: String? = null

    private var nodeName: String? = null

    private var outputFile: String? = null

    /**
     * @param value Honeypot ID.
     */
    @JvmName("eqqnrvhftstqirgk")
    public suspend fun honeypotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.honeypotId = mapped
    }

    /**
     * @param value Honeypot custom name.
     */
    @JvmName("nsxfmauhbbhjnotk")
    public suspend fun honeypotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.honeypotName = mapped
    }

    /**
     * @param value A list of Honey Pot IDs.
     */
    @JvmName("cdgsdrlhyykqtvcy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Honey Pot IDs.
     */
    @JvmName("qdiillbmwpycavff")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by honey pot name.
     */
    @JvmName("xewhtyvhudpisngk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The ID of the honeypot management node.
     */
    @JvmName("vixgndruahnxeugr")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value The name of the honeypot management node.
     */
    @JvmName("udbqyvxpxejqsvjg")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("luiivheklmmolajo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetHoneyPotsPlainArgs = GetHoneyPotsPlainArgs(
        honeypotId = honeypotId,
        honeypotName = honeypotName,
        ids = ids,
        nameRegex = nameRegex,
        nodeId = nodeId,
        nodeName = nodeName,
        outputFile = outputFile,
    )
}
