@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoneypotImages.
 * @property ids A list of Honeypot Image IDs.
 * @property nameRegex A regex string to filter results by Honeypot mirror nam.
 * @property nodeId
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetHoneypotImagesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val nodeId: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetHoneypotImagesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHoneypotImagesPlainArgs].
 */
@PulumiTagMarker
public class GetHoneypotImagesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var nodeId: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Honeypot Image IDs.
     */
    @JvmName("cudybhcqmiivatrl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Honeypot Image IDs.
     */
    @JvmName("hgmhwodjncmbfvbk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Honeypot mirror nam.
     */
    @JvmName("yupccohompasprik")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("uxuhutnjyroivoxc")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("cinderuhgudrchlm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetHoneypotImagesPlainArgs = GetHoneypotImagesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        nodeId = nodeId,
        outputFile = outputFile,
    )
}
