@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotNodesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoneypotNodes.
 * @property ids A list of Honeypot Node IDs.
 * @property nameRegex A regex string to filter results by Honeypot Node name.
 * @property nodeId Honeypot management node id.
 * @property nodeName The name of the management node.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetHoneypotNodesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetHoneypotNodesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetHoneypotNodesPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetHoneypotNodesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .nodeName(nodeName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHoneypotNodesPlainArgs].
 */
@PulumiTagMarker
public class GetHoneypotNodesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var nodeId: String? = null

    private var nodeName: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value A list of Honeypot Node IDs.
     */
    @JvmName("amixaebwptxmhojk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Honeypot Node IDs.
     */
    @JvmName("wwjgbnblqqvfabad")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Honeypot Node name.
     */
    @JvmName("fsuwypnbjakjrxmk")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value Honeypot management node id.
     */
    @JvmName("jkbdntteuhitquxu")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value The name of the management node.
     */
    @JvmName("cddsnhepgfustxbj")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("mfmsriongduqamjl")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("wyuvhnhgyueitunx")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("oglibmkvvducqpee")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetHoneypotNodesPlainArgs = GetHoneypotNodesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        nodeId = nodeId,
        nodeName = nodeName,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
