@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotPresetsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoneypotPresets.
 * @property currentPage
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property honeypotImageName Honeypot mirror name
 * @property ids A list of Honeypot Preset IDs.
 * @property lang
 * @property nodeId Unique id of management node
 * @property nodeName
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property presetName Honeypot template custom name
 */
public data class GetHoneypotPresetsPlainArgs(
    public val currentPage: Int? = null,
    public val enableDetails: Boolean? = null,
    public val honeypotImageName: String? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val presetName: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetHoneypotPresetsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetHoneypotPresetsPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetHoneypotPresetsPlainArgs.builder()
            .currentPage(currentPage?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .honeypotImageName(honeypotImageName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .nodeId(nodeId?.let({ args0 -> args0 }))
            .nodeName(nodeName?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .presetName(presetName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHoneypotPresetsPlainArgs].
 */
@PulumiTagMarker
public class GetHoneypotPresetsPlainArgsBuilder internal constructor() {
    private var currentPage: Int? = null

    private var enableDetails: Boolean? = null

    private var honeypotImageName: String? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var nodeId: String? = null

    private var nodeName: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var presetName: String? = null

    /**
     * @param value
     */
    @JvmName("tebnxlhjklesgkro")
    public suspend fun currentPage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.currentPage = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("farjisakkhdxmtkq")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Honeypot mirror name
     */
    @JvmName("tvglowkueryjelak")
    public suspend fun honeypotImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.honeypotImageName = mapped
    }

    /**
     * @param value A list of Honeypot Preset IDs.
     */
    @JvmName("ohuvfenbktlhdofb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Honeypot Preset IDs.
     */
    @JvmName("dqouuaubctqbabna")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("greihwbjwjjbtsee")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value Unique id of management node
     */
    @JvmName("dlvrypnsmklwhsgr")
    public suspend fun nodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeId = mapped
    }

    /**
     * @param value
     */
    @JvmName("purtggsolibxieph")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nodeName = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rebkhmsyhsnughye")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("uojkjcpjchimjfjl")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("mqexslcylgynmils")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value Honeypot template custom name
     */
    @JvmName("pvpysqfglhmgfjmd")
    public suspend fun presetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.presetName = mapped
    }

    internal fun build(): GetHoneypotPresetsPlainArgs = GetHoneypotPresetsPlainArgs(
        currentPage = currentPage,
        enableDetails = enableDetails,
        honeypotImageName = honeypotImageName,
        ids = ids,
        lang = lang,
        nodeId = nodeId,
        nodeName = nodeName,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        presetName = presetName,
    )
}
