@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetHoneypotProbesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHoneypotProbes.
 * @property displayName Probe name
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Honeypot Probe IDs.
 * @property nameRegex A regex string to filter results by display name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property probeStatus
 * @property probeType Probe type
 */
public data class GetHoneypotProbesPlainArgs(
    public val displayName: String? = null,
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val probeStatus: String? = null,
    public val probeType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetHoneypotProbesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetHoneypotProbesPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetHoneypotProbesPlainArgs.builder()
            .displayName(displayName?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .probeStatus(probeStatus?.let({ args0 -> args0 }))
            .probeType(probeType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHoneypotProbesPlainArgs].
 */
@PulumiTagMarker
public class GetHoneypotProbesPlainArgsBuilder internal constructor() {
    private var displayName: String? = null

    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var probeStatus: String? = null

    private var probeType: String? = null

    /**
     * @param value Probe name
     */
    @JvmName("snjvloskeurodouu")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.displayName = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("fydynggnlqhqbxsn")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Honeypot Probe IDs.
     */
    @JvmName("qdmgjeufeuffysbu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Honeypot Probe IDs.
     */
    @JvmName("glmsfpyotbekbndd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by display name.
     */
    @JvmName("nomndgvxggneaafa")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bdypsxkphwsibomm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("hiapfwakrclmwvbp")
    public suspend fun probeStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.probeStatus = mapped
    }

    /**
     * @param value Probe type
     */
    @JvmName("xjfcwvpbxqjkftep")
    public suspend fun probeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.probeType = mapped
    }

    internal fun build(): GetHoneypotProbesPlainArgs = GetHoneypotProbesPlainArgs(
        displayName = displayName,
        enableDetails = enableDetails,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        probeStatus = probeStatus,
        probeType = probeType,
    )
}
