@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetLogShipperPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLogShipper.
 * @property enable Setting the value to `On` to enable the service. Valid values: `On` or `Off`. Default to `Off`.
 * > **NOTE:** Setting `enable = "On"` to open the Threat Detection Log Shipper that means you have read and agreed the [Threat Detection Log Shipper Terms of Service](https://help.aliyun.com/document_detail/170157.html). The service can not closed once it is opened.
 */
public data class GetLogShipperPlainArgs(
    public val enable: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetLogShipperPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetLogShipperPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetLogShipperPlainArgs.builder()
            .enable(enable?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogShipperPlainArgs].
 */
@PulumiTagMarker
public class GetLogShipperPlainArgsBuilder internal constructor() {
    private var enable: String? = null

    /**
     * @param value Setting the value to `On` to enable the service. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Threat Detection Log Shipper that means you have read and agreed the [Threat Detection Log Shipper Terms of Service](https://help.aliyun.com/document_detail/170157.html). The service can not closed once it is opened.
     */
    @JvmName("sbknrdtwfmspvrtn")
    public suspend fun enable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enable = mapped
    }

    internal fun build(): GetLogShipperPlainArgs = GetLogShipperPlainArgs(
        enable = enable,
    )
}
