@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.GetWebLockConfigsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWebLockConfigs.
 * @property ids A list of Web Lock Config IDs.
 * @property lang The language of the content within the request and the response. Valid values: `zh`, `en`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property remark The string that allows you to search for servers in fuzzy match mode. You can enter a server name or IP address.
 * @property sourceIp The source IP address of the request.
 * @property status The protection status of the server that you want to query. Valid values: `on`, `off`.
 */
public data class GetWebLockConfigsPlainArgs(
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val remark: String? = null,
    public val sourceIp: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.GetWebLockConfigsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.GetWebLockConfigsPlainArgs =
        com.pulumi.alicloud.threatdetection.inputs.GetWebLockConfigsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .remark(remark?.let({ args0 -> args0 }))
            .sourceIp(sourceIp?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebLockConfigsPlainArgs].
 */
@PulumiTagMarker
public class GetWebLockConfigsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var remark: String? = null

    private var sourceIp: String? = null

    private var status: String? = null

    /**
     * @param value A list of Web Lock Config IDs.
     */
    @JvmName("rdcfqwcvamreurek")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Web Lock Config IDs.
     */
    @JvmName("mwfwqcuvdmntduph")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The language of the content within the request and the response. Valid values: `zh`, `en`.
     */
    @JvmName("ihikimocsqdodkhj")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ayqbwvfxwjhggbsm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("lojnwqoojvgnnvmj")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("cblxqrdhytqbplng")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The string that allows you to search for servers in fuzzy match mode. You can enter a server name or IP address.
     */
    @JvmName("ihpdokhumcgayxrl")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.remark = mapped
    }

    /**
     * @param value The source IP address of the request.
     */
    @JvmName("kolithicnpdauykv")
    public suspend fun sourceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceIp = mapped
    }

    /**
     * @param value The protection status of the server that you want to query. Valid values: `on`, `off`.
     */
    @JvmName("gpvyetjdqvkqcmnr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetWebLockConfigsPlainArgs = GetWebLockConfigsPlainArgs(
        ids = ids,
        lang = lang,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        remark = remark,
        sourceIp = sourceIp,
        status = status,
    )
}
