@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.HoneypotPresetMetaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property burp Burp counter.
 * @property portraitOption Social traceability.
 * @property trojanGit Git countered.
 */
public data class HoneypotPresetMetaArgs(
    public val burp: Output<String>,
    public val portraitOption: Output<Boolean>? = null,
    public val trojanGit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.HoneypotPresetMetaArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.HoneypotPresetMetaArgs =
        com.pulumi.alicloud.threatdetection.inputs.HoneypotPresetMetaArgs.builder()
            .burp(burp.applyValue({ args0 -> args0 }))
            .portraitOption(portraitOption?.applyValue({ args0 -> args0 }))
            .trojanGit(trojanGit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoneypotPresetMetaArgs].
 */
@PulumiTagMarker
public class HoneypotPresetMetaArgsBuilder internal constructor() {
    private var burp: Output<String>? = null

    private var portraitOption: Output<Boolean>? = null

    private var trojanGit: Output<String>? = null

    /**
     * @param value Burp counter.
     */
    @JvmName("yfwfhauhrrptdnyd")
    public suspend fun burp(`value`: Output<String>) {
        this.burp = value
    }

    /**
     * @param value Social traceability.
     */
    @JvmName("gvtkqicdigwhkqex")
    public suspend fun portraitOption(`value`: Output<Boolean>) {
        this.portraitOption = value
    }

    /**
     * @param value Git countered.
     */
    @JvmName("ektmfbagunyoaqju")
    public suspend fun trojanGit(`value`: Output<String>) {
        this.trojanGit = value
    }

    /**
     * @param value Burp counter.
     */
    @JvmName("eljbmfrsnrhpsvhd")
    public suspend fun burp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.burp = mapped
    }

    /**
     * @param value Social traceability.
     */
    @JvmName("bptqmboqdmxtiple")
    public suspend fun portraitOption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portraitOption = mapped
    }

    /**
     * @param value Git countered.
     */
    @JvmName("ryutypqlaassgggj")
    public suspend fun trojanGit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trojanGit = mapped
    }

    internal fun build(): HoneypotPresetMetaArgs = HoneypotPresetMetaArgs(
        burp = burp ?: throw PulumiNullFieldException("burp"),
        portraitOption = portraitOption,
        trojanGit = trojanGit,
    )
}
