@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bindPortLists List of listening ports.See the following `Block BindPortList`.
 * @property honeypotId Honeypot ID.
 */
public data class HoneypotProbeHoneypotBindListArgs(
    public val bindPortLists: Output<List<HoneypotProbeHoneypotBindListBindPortListArgs>>? = null,
    public val honeypotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs =
        com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListArgs.builder()
            .bindPortLists(
                bindPortLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .honeypotId(honeypotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoneypotProbeHoneypotBindListArgs].
 */
@PulumiTagMarker
public class HoneypotProbeHoneypotBindListArgsBuilder internal constructor() {
    private var bindPortLists: Output<List<HoneypotProbeHoneypotBindListBindPortListArgs>>? = null

    private var honeypotId: Output<String>? = null

    /**
     * @param value List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("ewbdbuxoyfiqandb")
    public suspend fun bindPortLists(`value`: Output<List<HoneypotProbeHoneypotBindListBindPortListArgs>>) {
        this.bindPortLists = value
    }

    @JvmName("rrfouyvtmsblvpbk")
    public suspend fun bindPortLists(vararg values: Output<HoneypotProbeHoneypotBindListBindPortListArgs>) {
        this.bindPortLists = Output.all(values.asList())
    }

    /**
     * @param values List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("jvwgdownvsvxqdwy")
    public suspend fun bindPortLists(values: List<Output<HoneypotProbeHoneypotBindListBindPortListArgs>>) {
        this.bindPortLists = Output.all(values)
    }

    /**
     * @param value Honeypot ID.
     */
    @JvmName("chnckekbgvolchqj")
    public suspend fun honeypotId(`value`: Output<String>) {
        this.honeypotId = value
    }

    /**
     * @param value List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("ejabnfxowtqojxqd")
    public suspend fun bindPortLists(`value`: List<HoneypotProbeHoneypotBindListBindPortListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindPortLists = mapped
    }

    /**
     * @param argument List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("dfciyqnyqydfephk")
    public suspend fun bindPortLists(argument: List<suspend HoneypotProbeHoneypotBindListBindPortListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HoneypotProbeHoneypotBindListBindPortListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bindPortLists = mapped
    }

    /**
     * @param argument List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("gpprtqgxdbxohaus")
    public suspend fun bindPortLists(vararg argument: suspend HoneypotProbeHoneypotBindListBindPortListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HoneypotProbeHoneypotBindListBindPortListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bindPortLists = mapped
    }

    /**
     * @param argument List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("btvlbmnhwklnmajs")
    public suspend fun bindPortLists(argument: suspend HoneypotProbeHoneypotBindListBindPortListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HoneypotProbeHoneypotBindListBindPortListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bindPortLists = mapped
    }

    /**
     * @param values List of listening ports.See the following `Block BindPortList`.
     */
    @JvmName("ebficvofhaxlpfsw")
    public suspend fun bindPortLists(vararg values: HoneypotProbeHoneypotBindListBindPortListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindPortLists = mapped
    }

    /**
     * @param value Honeypot ID.
     */
    @JvmName("ftgnracrypewrgwi")
    public suspend fun honeypotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeypotId = mapped
    }

    internal fun build(): HoneypotProbeHoneypotBindListArgs = HoneypotProbeHoneypotBindListArgs(
        bindPortLists = bindPortLists,
        honeypotId = honeypotId,
    )
}
