@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.inputs

import com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListBindPortListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bindPort Whether to bind the port.
 * @property endPort End port.
 * @property fixed Whether the port is fixed.
 * @property startPort Start port.
 * @property targetPort Destination port.
 */
public data class HoneypotProbeHoneypotBindListBindPortListArgs(
    public val bindPort: Output<Boolean>? = null,
    public val endPort: Output<Int>? = null,
    public val fixed: Output<Boolean>? = null,
    public val startPort: Output<Int>? = null,
    public val targetPort: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListBindPortListArgs> {
    override fun toJava(): com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListBindPortListArgs =
        com.pulumi.alicloud.threatdetection.inputs.HoneypotProbeHoneypotBindListBindPortListArgs.builder()
            .bindPort(bindPort?.applyValue({ args0 -> args0 }))
            .endPort(endPort?.applyValue({ args0 -> args0 }))
            .fixed(fixed?.applyValue({ args0 -> args0 }))
            .startPort(startPort?.applyValue({ args0 -> args0 }))
            .targetPort(targetPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoneypotProbeHoneypotBindListBindPortListArgs].
 */
@PulumiTagMarker
public class HoneypotProbeHoneypotBindListBindPortListArgsBuilder internal constructor() {
    private var bindPort: Output<Boolean>? = null

    private var endPort: Output<Int>? = null

    private var fixed: Output<Boolean>? = null

    private var startPort: Output<Int>? = null

    private var targetPort: Output<Int>? = null

    /**
     * @param value Whether to bind the port.
     */
    @JvmName("caqwgosrfnyefjdp")
    public suspend fun bindPort(`value`: Output<Boolean>) {
        this.bindPort = value
    }

    /**
     * @param value End port.
     */
    @JvmName("imtwgatvvhnbsciq")
    public suspend fun endPort(`value`: Output<Int>) {
        this.endPort = value
    }

    /**
     * @param value Whether the port is fixed.
     */
    @JvmName("yudwrgknefipyyyv")
    public suspend fun fixed(`value`: Output<Boolean>) {
        this.fixed = value
    }

    /**
     * @param value Start port.
     */
    @JvmName("qovocwufqnjsityh")
    public suspend fun startPort(`value`: Output<Int>) {
        this.startPort = value
    }

    /**
     * @param value Destination port.
     */
    @JvmName("wiesjcgyjggffaoq")
    public suspend fun targetPort(`value`: Output<Int>) {
        this.targetPort = value
    }

    /**
     * @param value Whether to bind the port.
     */
    @JvmName("afjfvpsxyxtmwcfm")
    public suspend fun bindPort(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindPort = mapped
    }

    /**
     * @param value End port.
     */
    @JvmName("nvxhuloaheqaqbpj")
    public suspend fun endPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endPort = mapped
    }

    /**
     * @param value Whether the port is fixed.
     */
    @JvmName("xetortwsjqsjtrlm")
    public suspend fun fixed(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixed = mapped
    }

    /**
     * @param value Start port.
     */
    @JvmName("rgnxwakysdkedxiv")
    public suspend fun startPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startPort = mapped
    }

    /**
     * @param value Destination port.
     */
    @JvmName("hfsndqgvfhwlkfbj")
    public suspend fun targetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPort = mapped
    }

    internal fun build(): HoneypotProbeHoneypotBindListBindPortListArgs =
        HoneypotProbeHoneypotBindListBindPortListArgs(
            bindPort = bindPort,
            endPort = endPort,
            fixed = fixed,
            startPort = startPort,
            targetPort = targetPort,
        )
}
