@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAntiBruteForceRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Anti Brute Force Rule IDs.
 * @property nameRegex
 * @property names A list of name of Anti Brute Force Rules.
 * @property outputFile
 * @property rules A list of Anti Brute Force Rule Entries. Each element contains the following attributes:
 */
public data class GetAntiBruteForceRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetAntiBruteForceRulesRule>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetAntiBruteForceRulesResult): GetAntiBruteForceRulesResult = GetAntiBruteForceRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAntiBruteForceRulesRule.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
