@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property antiBruteForceRuleId The ID of the defense rule.
 * @property antiBruteForceRuleName The name of the defense rule.
 * @property defaultRule Specifies whether to set the defense rule as the default rule.
 * @property failCount The threshold for the number of failed user logins when the brute-force defense rule takes effect.
 * @property forbiddenTime The period of time during which logons from an account are not allowed. Unit: minutes.
 * @property id The ID of the defense rule.
 * @property span The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
 * @property uuidLists An array consisting of the UUIDs of servers to which the defense rule is applied.
 */
public data class GetAntiBruteForceRulesRule(
    public val antiBruteForceRuleId: String,
    public val antiBruteForceRuleName: String,
    public val defaultRule: Boolean,
    public val failCount: Int,
    public val forbiddenTime: Int,
    public val id: String,
    public val span: Int,
    public val uuidLists: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetAntiBruteForceRulesRule): GetAntiBruteForceRulesRule = GetAntiBruteForceRulesRule(
            antiBruteForceRuleId = javaType.antiBruteForceRuleId(),
            antiBruteForceRuleName = javaType.antiBruteForceRuleName(),
            defaultRule = javaType.defaultRule(),
            failCount = javaType.failCount(),
            forbiddenTime = javaType.forbiddenTime(),
            id = javaType.id(),
            span = javaType.span(),
            uuidLists = javaType.uuidLists().map({ args0 -> args0 }),
        )
    }
}
