@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAssets.
 * @property assets A list of Asset Entries. Each element contains the following attributes:
 * @property criteria
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Asset IDs.
 * @property importance
 * @property logicalExp
 * @property machineTypes
 * @property noGroupTrace
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetAssetsResult(
    public val assets: List<GetAssetsAsset>,
    public val criteria: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val importance: Int? = null,
    public val logicalExp: String? = null,
    public val machineTypes: String? = null,
    public val noGroupTrace: Boolean? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetAssetsResult): GetAssetsResult = GetAssetsResult(
            assets = javaType.assets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetAssetsAsset.Companion.toKotlin(args0)
                })
            }),
            criteria = javaType.criteria().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            importance = javaType.importance().map({ args0 -> args0 }).orElse(null),
            logicalExp = javaType.logicalExp().map({ args0 -> args0 }).orElse(null),
            machineTypes = javaType.machineTypes().map({ args0 -> args0 }).orElse(null),
            noGroupTrace = javaType.noGroupTrace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
