@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupPolicyId The ID of the anti-ransomware policy.
 * @property backupPolicyName The name of the anti-ransomware policy.
 * @property id The ID of the anti-ransomware policy.
 * @property policy The configurations of the anti-ransomware policy.
 * @property policyRegionId The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
 * @property policyVersion The version of the anti-ransomware policy.
 * @property status The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
 * @property uuidLists The UUIDs of the servers to which the anti-ransomware policy is applied.
 */
public data class GetBackupPoliciesPolicy(
    public val backupPolicyId: Int,
    public val backupPolicyName: String,
    public val id: Int,
    public val policy: String,
    public val policyRegionId: String,
    public val policyVersion: String,
    public val status: String,
    public val uuidLists: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetBackupPoliciesPolicy): GetBackupPoliciesPolicy = GetBackupPoliciesPolicy(
            backupPolicyId = javaType.backupPolicyId(),
            backupPolicyName = javaType.backupPolicyName(),
            id = javaType.id(),
            policy = javaType.policy(),
            policyRegionId = javaType.policyRegionId(),
            policyVersion = javaType.policyVersion(),
            status = javaType.status(),
            uuidLists = javaType.uuidLists().map({ args0 -> args0 }),
        )
    }
}
