@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBackupPolicies.
 * @property currentPage
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property machineRemark
 * @property name
 * @property nameRegex
 * @property names A list of Threat Detection Backup Policy names.
 * @property outputFile
 * @property pageSize
 * @property policies A list of Threat Detection Backup policies. Each element contains the following attributes:
 * @property status The status of the anti-ransomware policy.
 */
public data class GetBackupPoliciesResult(
    public val currentPage: Int? = null,
    public val id: String,
    public val ids: List<String>,
    public val machineRemark: String? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageSize: Int? = null,
    public val policies: List<GetBackupPoliciesPolicy>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetBackupPoliciesResult): GetBackupPoliciesResult = GetBackupPoliciesResult(
            currentPage = javaType.currentPage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            machineRemark = javaType.machineRemark().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBackupPoliciesPolicy.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
