@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBaselineStrategies.
 * @property customType The type of policy. Value:
 * * **common**: standard policy
 * * **custom**: custom policy
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Baseline Strategy IDs.
 * @property nameRegex
 * @property names A list of name of Baseline Strategys.
 * @property outputFile
 * @property strategies
 * @property strategyIds
 */
public data class GetBaselineStrategiesResult(
    public val customType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val strategies: List<GetBaselineStrategiesStrategy>,
    public val strategyIds: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetBaselineStrategiesResult): GetBaselineStrategiesResult = GetBaselineStrategiesResult(
            customType = javaType.customType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            strategies = javaType.strategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetBaselineStrategiesStrategy.Companion.toKotlin(args0)
                })
            }),
            strategyIds = javaType.strategyIds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
