@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property baselineStrategyId The ID of the baseline check policy.
 * @property baselineStrategyName Policy name.
 * @property customType The type of policy. Value:-**common**: standard policy-**custom**: custom policy
 * @property cycleDays The detection period of the policy.
 * @property cycleStartTime The detection period of the policy. Value:
 * * **0**: 0:00~06:00
 * * **6**: 6:00~12:00
 * * *12**: 12:00~18:00
 * * **18**: 18:00~24:00
 * @property endTime The baseline check policy execution end time.
 * @property id The ID of the baseline check policy.
 * @property riskSubTypeName
 * @property startTime The baseline check policy start time.
 * @property targetType
 */
public data class GetBaselineStrategiesStrategy(
    public val baselineStrategyId: String,
    public val baselineStrategyName: String,
    public val customType: String,
    public val cycleDays: Int,
    public val cycleStartTime: Int,
    public val endTime: String,
    public val id: String,
    public val riskSubTypeName: String,
    public val startTime: String,
    public val targetType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetBaselineStrategiesStrategy): GetBaselineStrategiesStrategy = GetBaselineStrategiesStrategy(
            baselineStrategyId = javaType.baselineStrategyId(),
            baselineStrategyName = javaType.baselineStrategyName(),
            customType = javaType.customType(),
            cycleDays = javaType.cycleDays(),
            cycleStartTime = javaType.cycleStartTime(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            riskSubTypeName = javaType.riskSubTypeName(),
            startTime = javaType.startTime(),
            targetType = javaType.targetType(),
        )
    }
}
