@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property honeypotId Honeypot ID.
 * @property honeypotImageId The image ID of the honeypot.
 * @property honeypotImageName Honeypot mirror name.
 * @property honeypotName Honeypot custom name.
 * @property id Honeypot ID. The value is the same as `honeypot_id`.
 * @property nodeId The ID of the honeypot management node.
 * @property presetId The custom parameter ID of honeypot.
 * @property states Honeypot status.
 * @property status The status of the resource
 */
public data class GetHoneyPotsPot(
    public val honeypotId: String,
    public val honeypotImageId: String,
    public val honeypotImageName: String,
    public val honeypotName: String,
    public val id: String,
    public val nodeId: String,
    public val presetId: String,
    public val states: List<String>,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneyPotsPot): GetHoneyPotsPot = GetHoneyPotsPot(
            honeypotId = javaType.honeypotId(),
            honeypotImageId = javaType.honeypotImageId(),
            honeypotImageName = javaType.honeypotImageName(),
            honeypotName = javaType.honeypotName(),
            id = javaType.id(),
            nodeId = javaType.nodeId(),
            presetId = javaType.presetId(),
            states = javaType.states().map({ args0 -> args0 }),
            status = javaType.status(),
        )
    }
}
