@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHoneyPots.
 * @property honeypotId Honeypot ID.
 * @property honeypotName Honeypot custom name.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Honey Pot IDs.
 * @property nameRegex
 * @property nodeId The ID of the honeypot management node.
 * @property nodeName
 * @property outputFile
 * @property pots A list of Honey Pot Entries. Each element contains the following attributes:
 */
public data class GetHoneyPotsResult(
    public val honeypotId: String? = null,
    public val honeypotName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val outputFile: String? = null,
    public val pots: List<GetHoneyPotsPot>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneyPotsResult): GetHoneyPotsResult = GetHoneyPotsResult(
            honeypotId = javaType.honeypotId().map({ args0 -> args0 }).orElse(null),
            honeypotName = javaType.honeypotName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pots = javaType.pots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneyPotsPot.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
