@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property honeypotImageDisplayName The name of the honeypot image display.
 * @property honeypotImageId The image ID of the honeypot.
 * @property honeypotImageName Honeypot mirror name.
 * @property honeypotImageType Honeypot mirror type.
 * @property honeypotImageVersion Honeypot Mirror version.
 * @property id The image ID of the honeypot.The value is the same as `honeypot_image_id`.
 * @property multiports Ports supported by honeypots. In JSON format. Contains the following fields:-**log_type**: log type-**proto**: Support Protocol-**description**: description-**ports**: supports Port collection-**port_str**: supports port strings-**type**: type
 * @property proto Honeypot-supported protocols.
 * @property servicePort Honeypot service port.
 * @property template Honeypot configuration parameter template.
 */
public data class GetHoneypotImagesImage(
    public val honeypotImageDisplayName: String,
    public val honeypotImageId: String,
    public val honeypotImageName: String,
    public val honeypotImageType: String,
    public val honeypotImageVersion: String,
    public val id: String,
    public val multiports: String,
    public val proto: String,
    public val servicePort: String,
    public val template: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotImagesImage): GetHoneypotImagesImage = GetHoneypotImagesImage(
            honeypotImageDisplayName = javaType.honeypotImageDisplayName(),
            honeypotImageId = javaType.honeypotImageId(),
            honeypotImageName = javaType.honeypotImageName(),
            honeypotImageType = javaType.honeypotImageType(),
            honeypotImageVersion = javaType.honeypotImageVersion(),
            id = javaType.id(),
            multiports = javaType.multiports(),
            proto = javaType.proto(),
            servicePort = javaType.servicePort(),
            template = javaType.template(),
        )
    }
}
