@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHoneypotImages.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Honeypot Image IDs.
 * @property images A list of Honeypot Image Entries. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of name of Honeypot Images.
 * @property nodeId
 * @property outputFile
 */
public data class GetHoneypotImagesResult(
    public val id: String,
    public val ids: List<String>,
    public val images: List<GetHoneypotImagesImage>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val nodeId: String? = null,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotImagesResult): GetHoneypotImagesResult = GetHoneypotImagesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotImagesImage.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
