@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowHoneypotAccessInternet Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
 * @property availableProbeNum Number of probes available.
 * @property createTime
 * @property id The ID of the Honeypot management node.
 * @property nodeId Honeypot management node id.
 * @property nodeName The name of the management node.
 * @property securityGroupProbeIpLists Release the collection of network segments.
 * @property status
 */
public data class GetHoneypotNodesNode(
    public val allowHoneypotAccessInternet: Boolean,
    public val availableProbeNum: Int,
    public val createTime: String,
    public val id: String,
    public val nodeId: String,
    public val nodeName: String,
    public val securityGroupProbeIpLists: List<String>,
    public val status: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotNodesNode): GetHoneypotNodesNode = GetHoneypotNodesNode(
            allowHoneypotAccessInternet = javaType.allowHoneypotAccessInternet(),
            availableProbeNum = javaType.availableProbeNum(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            nodeId = javaType.nodeId(),
            nodeName = javaType.nodeName(),
            securityGroupProbeIpLists = javaType.securityGroupProbeIpLists().map({ args0 -> args0 }),
            status = javaType.status(),
        )
    }
}
