@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHoneypotNodes.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Honeypot Node IDs.
 * @property nameRegex
 * @property names A list of Honeypot Node names.
 * @property nodeId Honeypot management node id.
 * @property nodeName Management node name.
 * @property nodes A list of Honeypot Node Entries. Each element contains the following attributes:
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetHoneypotNodesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val nodes: List<GetHoneypotNodesNode>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotNodesResult): GetHoneypotNodesResult = GetHoneypotNodesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotNodesNode.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
