@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property honeypotImageName Honeypot mirror name
 * @property honeypotPresetId Unique ID of honeypot Template.
 * @property id The id of the Honeypot template.
 * @property metas Honeypot template custom parameters.
 * @property nodeId Unique id of management node
 * @property presetName Honeypot template custom name
 */
public data class GetHoneypotPresetsPreset(
    public val honeypotImageName: String,
    public val honeypotPresetId: String,
    public val id: String,
    public val metas: List<GetHoneypotPresetsPresetMeta>,
    public val nodeId: String,
    public val presetName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotPresetsPreset): GetHoneypotPresetsPreset = GetHoneypotPresetsPreset(
            honeypotImageName = javaType.honeypotImageName(),
            honeypotPresetId = javaType.honeypotPresetId(),
            id = javaType.id(),
            metas = javaType.metas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotPresetsPresetMeta.Companion.toKotlin(args0)
                })
            }),
            nodeId = javaType.nodeId(),
            presetName = javaType.presetName(),
        )
    }
}
