@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property burp Burp counter.
 * @property portraitOption Social traceability.
 * @property trojanGit Git countered.
 */
public data class GetHoneypotPresetsPresetMeta(
    public val burp: String,
    public val portraitOption: Boolean,
    public val trojanGit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotPresetsPresetMeta): GetHoneypotPresetsPresetMeta = GetHoneypotPresetsPresetMeta(
            burp = javaType.burp(),
            portraitOption = javaType.portraitOption(),
            trojanGit = javaType.trojanGit(),
        )
    }
}
