@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHoneypotPresets.
 * @property currentPage
 * @property enableDetails
 * @property honeypotImageName Honeypot mirror name.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Honeypot Preset IDs.
 * @property lang
 * @property nodeId Unique id of management node.
 * @property nodeName
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property presetName Honeypot template custom name.
 * @property presets A list of Honeypot Preset Entries. Each element contains the following attributes:
 */
public data class GetHoneypotPresetsResult(
    public val currentPage: Int? = null,
    public val enableDetails: Boolean? = null,
    public val honeypotImageName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val nodeId: String? = null,
    public val nodeName: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val presetName: String? = null,
    public val presets: List<GetHoneypotPresetsPreset>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotPresetsResult): GetHoneypotPresetsResult = GetHoneypotPresetsResult(
            currentPage = javaType.currentPage().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            honeypotImageName = javaType.honeypotImageName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            nodeId = javaType.nodeId().map({ args0 -> args0 }).orElse(null),
            nodeName = javaType.nodeName().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            presetName = javaType.presetName().map({ args0 -> args0 }).orElse(null),
            presets = javaType.presets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotPresetsPreset.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
