@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arp ARP spoofing detection.-**true**: Enable-**false**: Disabled. Available when `enable_details` is on.
 * @property controlNodeId The ID of the management node.
 * @property displayName Probe name
 * @property honeypotBindLists
 * @property honeypotProbeId The first ID of the resource
 * @property id The ID of the honeypot probe. Its value is the same as `honeypot_probe_id`.
 * @property ping Ping scan detection. Value:**true**: Enable **false**: Disabled. Available when `enable_details` is on.
 * @property probeType Probe type
 * @property serviceIpLists Listen to the IP address list. Available when `enable_details` is on.
 * @property status The status of the resource.
 * @property uuid Machine uuid. Has a value when the type is `host_probe`.
 * @property vpcId The ID of the VPC. Has a value when the type is `vpc_black_hole_probe`.
 */
public data class GetHoneypotProbesProbe(
    public val arp: Boolean,
    public val controlNodeId: String,
    public val displayName: String,
    public val honeypotBindLists: List<GetHoneypotProbesProbeHoneypotBindList>,
    public val honeypotProbeId: String,
    public val id: String,
    public val ping: Boolean,
    public val probeType: String,
    public val serviceIpLists: List<String>,
    public val status: String,
    public val uuid: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotProbesProbe): GetHoneypotProbesProbe = GetHoneypotProbesProbe(
            arp = javaType.arp(),
            controlNodeId = javaType.controlNodeId(),
            displayName = javaType.displayName(),
            honeypotBindLists = javaType.honeypotBindLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotProbesProbeHoneypotBindList.Companion.toKotlin(args0)
                })
            }),
            honeypotProbeId = javaType.honeypotProbeId(),
            id = javaType.id(),
            ping = javaType.ping(),
            probeType = javaType.probeType(),
            serviceIpLists = javaType.serviceIpLists().map({ args0 -> args0 }),
            status = javaType.status(),
            uuid = javaType.uuid(),
            vpcId = javaType.vpcId(),
        )
    }
}
