@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHoneypotProbes.
 * @property displayName Probe name.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Honeypot Probe IDs.
 * @property nameRegex
 * @property outputFile
 * @property probeStatus
 * @property probeType Probe type, support `host_probe` and `vpc_black_hole_probe`.
 * @property probes A list of Honeypot Probe Entries. Each element contains the following attributes:
 */
public data class GetHoneypotProbesResult(
    public val displayName: String? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val probeStatus: String? = null,
    public val probeType: String? = null,
    public val probes: List<GetHoneypotProbesProbe>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetHoneypotProbesResult): GetHoneypotProbesResult = GetHoneypotProbesResult(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            probeStatus = javaType.probeStatus().map({ args0 -> args0 }).orElse(null),
            probeType = javaType.probeType().map({ args0 -> args0 }).orElse(null),
            probes = javaType.probes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetHoneypotProbesProbe.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
